/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.defaults.methodnum;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.methodnum.ActionParameterDefaultsFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class ActionParameterDefaultsFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterManagerAware {
    private static final String[] PREFIXES = new String[0];
    private AdapterManager adapterManager;

    public ActionParameterDefaultsFacetViaMethodFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List<FacetedMethodParameter> holderList = facetedMethod.getParameters();
        this.attachDefaultFacetForParametersIfDefaultsNumMethodIsFound(processMethodContext, holderList);
    }

    private void attachDefaultFacetForParametersIfDefaultsNumMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Method defaultMethod = ActionParameterDefaultsFacetViaMethodFactory.findDefaultNumMethod(processMethodContext, i);
            if (defaultMethod == null) continue;
            processMethodContext.removeMethod(defaultMethod);
            FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
            if (facetedMethod.containsDoOpFacet(ActionDefaultsFacet.class)) {
                Class<?> cls2 = processMethodContext.getCls();
                throw new MetaModelException(cls2 + " uses both old and new default syntax for " + actionMethod.getName() + "(...) - must use one or other");
            }
            FacetedMethodParameter paramAsHolder = parameters.get(i);
            FacetUtil.addFacet(new ActionParameterDefaultsFacetViaMethod(defaultMethod, (FacetHolder)paramAsHolder, this.getAdapterManager()));
        }
    }

    private static Method findDefaultNumMethod(FacetFactory.ProcessMethodContext processMethodContext, int n) {
        Method actionMethod = processMethodContext.getMethod();
        List<Class<?>> paramTypes = ListExtensions.mutableCopy(actionMethod.getParameterTypes());
        int numParamTypes = paramTypes.size();
        for (int i = 0; i < numParamTypes + 1; ++i) {
            Method method = ActionParameterDefaultsFacetViaMethodFactory.findDefaultNumMethod(processMethodContext, n, paramTypes.toArray(new Class[0]));
            if (method != null) {
                return method;
            }
            if (paramTypes.isEmpty()) continue;
            paramTypes.remove(paramTypes.size() - 1);
        }
        return null;
    }

    private static Method findDefaultNumMethod(FacetFactory.ProcessMethodContext processMethodContext, int n, Class<?>[] paramTypes) {
        Class<?> cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        Class<?> returnType = actionMethod.getParameterTypes()[n];
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        return MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "default" + n + capitalizedName, returnType, paramTypes);
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

