/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.choices.methodnum;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public class ActionParameterChoicesFacetViaMethod
extends ActionParameterChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;

    public ActionParameterChoicesFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLoader specificationLookup, AdapterManager adapterManager) {
        super(holder, specificationLookup, adapterManager);
        this.method = method;
        this.choicesType = choicesType;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object[] getChoices(ObjectAdapter adapter, List<ObjectAdapter> argumentsIfAvailable, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        Object choices = ObjectAdapter.InvokeUtils.invokeAutofit(this.method, adapter, argumentsIfAvailable, this.getAdapterManager());
        if (choices == null) {
            return new Object[0];
        }
        ObjectAdapter objectAdapter = this.getAdapterManager().adapterFor(choices);
        FacetedMethodParameter facetedMethodParameter = (FacetedMethodParameter)this.getFacetHolder();
        Class<?> parameterType = facetedMethodParameter.getType();
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(objectAdapter, authenticationSession, deploymentCategory);
        ArrayList visibleObjects = Lists.newArrayList((Iterable)Iterables.transform(visibleAdapters, ObjectAdapter.Functions.getObject()));
        ObjectSpecification parameterSpec = this.getSpecification(parameterType);
        return CollectionUtils.getCollectionAsObjectArray(visibleObjects, parameterSpec, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }
}

