/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.choices.method;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionChoicesFacetAbstract;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public class ActionChoicesFacetViaMethod
extends ActionChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;
    private final SpecificationLoader specificationLoader;
    private final AdapterManager adapterManager;

    public ActionChoicesFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLoader specificationLoader, AdapterManager adapterManager) {
        super(holder);
        this.method = method;
        this.choicesType = choicesType;
        this.specificationLoader = specificationLoader;
        this.adapterManager = adapterManager;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object[][] getChoices(ObjectAdapter owningAdapter, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        Object objectOrCollection = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (!(objectOrCollection instanceof Object[])) {
            throw new DomainModelException(String.format("Expected an array of collections (Object[]) containing choices for all parameters, but got %s instead. Perhaps the parameter number is missing?", objectOrCollection));
        }
        Object[] options = (Object[])objectOrCollection;
        Object[][] results = new Object[options.length][];
        for (int i = 0; i < results.length; ++i) {
            Class<?> parameterType = this.method.getParameterTypes()[i];
            results[i] = this.handleResults(options[i], parameterType, authenticationSession, deploymentCategory);
        }
        return results;
    }

    private Object[] handleResults(Object collectionOrArray, Class<?> parameterType, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        if (collectionOrArray == null) {
            return null;
        }
        ObjectAdapter collectionAdapter = this.getAdapterManager().adapterFor(collectionOrArray);
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, authenticationSession, deploymentCategory);
        ArrayList filteredObjects = Lists.newArrayList((Iterable)Iterables.transform(visibleAdapters, ObjectAdapter.Functions.getObject()));
        ObjectSpecification parameterSpec = this.getSpecification(parameterType);
        return CollectionUtils.getCollectionAsObjectArray(filteredObjects, parameterSpec, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }

    protected ObjectSpecification getSpecification(Class<?> type) {
        return type != null ? this.getSpecificationLoader().loadSpecification(type) : null;
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

