/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.autocomplete.method;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.param.autocomplete.method.ActionParameterAutoCompleteFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class ActionParameterAutoCompleteFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterManagerAware {
    private static final String[] PREFIXES = new String[]{"autoComplete"};
    private AdapterManager adapterManager;

    public ActionParameterAutoCompleteFacetViaMethodFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List<FacetedMethodParameter> holderList = facetedMethod.getParameters();
        this.attachAutoCompleteFacetForParametersIfAutoCompleteNumMethodIsFound(processMethodContext, holderList);
    }

    private void attachAutoCompleteFacetForParametersIfAutoCompleteNumMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] params = actionMethod.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> paramType = params[i];
            Class<?> arrayOfParamType = Array.newInstance(paramType, 0).getClass();
            Method autoCompleteMethod = this.findAutoCompleteNumMethodReturning(processMethodContext, i, arrayOfParamType);
            if (autoCompleteMethod == null) {
                autoCompleteMethod = this.findAutoCompleteNumMethodReturning(processMethodContext, i, List.class);
            }
            if (autoCompleteMethod == null) continue;
            processMethodContext.removeMethod(autoCompleteMethod);
            FacetedMethodParameter paramAsHolder = parameters.get(i);
            FacetUtil.addFacet(new ActionParameterAutoCompleteFacetViaMethod(autoCompleteMethod, paramType, paramAsHolder, this.getSpecificationLoader(), this.getAdapterManager()));
        }
    }

    private Method findAutoCompleteNumMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, int i, Class<?> paramType) {
        Class<?> cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        String name = "autoComplete" + i + capitalizedName;
        return MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, name, paramType, new Class[]{String.class});
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

