/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.objectvalue.mustsatisfyspec;

import java.util.List;
import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.spec.Specification;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.mustsatisfyspec.MustSatisfySpecificationFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mustsatisfyspec.SpecificationEvaluator;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public abstract class MustSatisfySpecificationFacetAbstract
extends FacetAbstract
implements MustSatisfySpecificationFacet {
    private final List<Specification> specifications;
    private final SpecificationEvaluator specificationEvaluator;

    public static Class<? extends Facet> type() {
        return MustSatisfySpecificationFacet.class;
    }

    public List<Specification> getSpecifications() {
        return this.specifications;
    }

    public MustSatisfySpecificationFacetAbstract(List<Specification> specifications, FacetHolder holder, ServicesInjector servicesInjector) {
        super(MustSatisfySpecificationFacetAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.specifications = specifications;
        TranslationService translationService = servicesInjector.lookupService(TranslationService.class);
        String translationContext = ((IdentifiedHolder)holder).getIdentifier().toClassAndNameIdentityString();
        this.specificationEvaluator = new SpecificationEvaluator(translationService, translationContext);
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> validityContext) {
        if (!(validityContext instanceof ProposedHolder)) {
            return null;
        }
        ProposedHolder proposedHolder = (ProposedHolder)((Object)validityContext);
        ObjectAdapter proposedAdapter = proposedHolder.getProposed();
        if (proposedAdapter == null) {
            return null;
        }
        Object proposedObject = proposedAdapter.getObject();
        return this.specificationEvaluator.evaluation().evaluate(this.specifications, proposedObject).getReason();
    }

    protected static Specification newSpecificationElseNull(Class<?> value) {
        if (!Specification.class.isAssignableFrom(value)) {
            return null;
        }
        try {
            return (Specification)value.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

