/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.value.annotcfg;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.object.value.annotcfg.ValueFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.value.annotcfg.ValueFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderUtil;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class ValueFacetAnnotationOrConfigurationFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware,
AuthenticationSessionProviderAware,
AdapterManagerAware,
ServicesInjectorAware,
RuntimeContextAware {
    private IsisConfiguration configuration;
    private RuntimeContext runtimeContext;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private AdapterManager adapterManager;
    private ServicesInjector servicesInjector;

    public ValueFacetAnnotationOrConfigurationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet(this.create(processClassContaxt.getCls(), (FacetHolder)processClassContaxt.getFacetHolder()));
    }

    private ValueFacet create(Class<?> cls, FacetHolder holder) {
        ValueFacetFromConfiguration facet;
        ValueFacetAnnotation facet2;
        Value annotation = Annotations.getAnnotation(cls, Value.class);
        if (annotation != null && (facet2 = new ValueFacetAnnotation(cls, holder, this.getIsisConfiguration(), this.createValueSemanticsProviderContext())).isValid()) {
            return facet2;
        }
        String semanticsProviderName = ValueSemanticsProviderUtil.semanticsProviderNameFromConfiguration(cls, this.configuration);
        if (!Strings.isNullOrEmpty((String)semanticsProviderName) && (facet = new ValueFacetFromConfiguration(semanticsProviderName, holder, this.getIsisConfiguration(), this.createValueSemanticsProviderContext())).isValid()) {
            return facet;
        }
        return null;
    }

    protected ValueSemanticsProviderContext createValueSemanticsProviderContext() {
        return new ValueSemanticsProviderContext(this.getDeploymentCategory(), this.getAuthenticationSessionProvider(), this.getSpecificationLoader(), this.getAdapterManager(), this.getServicesInjector());
    }

    private DeploymentCategory getDeploymentCategory() {
        return this.runtimeContext.getDeploymentCategory();
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    @Override
    public void setAuthenticationSessionProvider(AuthenticationSessionProvider authenticationSessionProvider) {
        this.authenticationSessionProvider = authenticationSessionProvider;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    @Override
    public void setServicesInjector(ServicesInjector dependencyInjector) {
        this.servicesInjector = dependencyInjector;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

