/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.validating.validateobject.method;

import java.lang.reflect.Method;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.validating.validateobject.method.ValidateObjectFacetMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class ValidateObjectFacetMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements ServicesInjectorAware {
    private static final String VALIDATE_PREFIX = "validate";
    private static final String[] PREFIXES = new String[]{"validate"};
    private ServicesInjector servicesInjector;

    public ValidateObjectFacetMethodFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, VALIDATE_PREFIX, new Class[]{String.class, TranslatableString.class}, NO_PARAMETERS_TYPES);
        if (method != null) {
            TranslationService translationService = this.servicesInjector.lookupService(TranslationService.class);
            String translationContext = ((IdentifiedHolder)facetHolder).getIdentifier().toClassIdentityString();
            FacetUtil.addFacet(new ValidateObjectFacetMethod(method, translationService, translationContext, (FacetHolder)facetHolder));
            processClassContext.removeMethod(method);
        }
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

