/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.title.methods;

import java.lang.reflect.Method;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.title.methods.TitleFacetViaTitleMethod;
import org.apache.isis.core.metamodel.facets.object.title.methods.TitleFacetViaToStringMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class TitleFacetViaMethodsFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements ServicesInjectorAware {
    private static final String TO_STRING = "toString";
    private static final String TITLE = "title";
    private static final String[] PREFIXES = new String[]{"toString", "title"};
    private ServicesInjector servicesInjector;

    public TitleFacetViaMethodsFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        TitleFacet facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TITLE, new Class[]{String.class, TranslatableString.class}, null);
        if (method != null) {
            processClassContext.removeMethod(method);
            TranslationService translationService = this.servicesInjector.lookupService(TranslationService.class);
            String translationContext = method.getDeclaringClass().getName() + "#" + method.getName() + "()";
            TitleFacetViaTitleMethod facet = new TitleFacetViaTitleMethod(method, translationService, translationContext, (FacetHolder)((Object)facetHolder));
            FacetUtil.addFacet(facet);
            return;
        }
        TitleFacet existingTitleFacet = facetHolder.getFacet(TitleFacet.class);
        if (existingTitleFacet != null && !existingTitleFacet.isNoop()) {
            return;
        }
        try {
            method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TO_STRING, String.class, null);
            if (method == null) {
                return;
            }
            if (ClassExtensions.isJavaClass(method.getDeclaringClass())) {
                return;
            }
            processClassContext.removeMethod(method);
            FacetUtil.addFacet(new TitleFacetViaToStringMethod(method, (FacetHolder)((Object)facetHolder)));
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

