/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.parseable.parser;

import java.util.IllegalFormatException;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.adapters.ParsingException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.interactions.ParseValueContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class ParseableFacetUsingParser
extends FacetAbstract
implements ParseableFacet {
    private final Parser<?> parser;
    private final DeploymentCategory deploymentCategory;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ServicesInjector dependencyInjector;
    private final AdapterManager adapterManager;

    public ParseableFacetUsingParser(Parser<?> parser, FacetHolder holder, DeploymentCategory deploymentCategory, AuthenticationSessionProvider authenticationSessionProvider, ServicesInjector dependencyInjector, AdapterManager adapterManager) {
        super(ParseableFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.parser = parser;
        this.deploymentCategory = deploymentCategory;
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.dependencyInjector = dependencyInjector;
        this.adapterManager = adapterManager;
    }

    @Override
    protected String toStringValues() {
        this.dependencyInjector.injectServicesInto(this.parser);
        return this.parser.toString();
    }

    @Override
    public ObjectAdapter parseTextEntry(ObjectAdapter contextAdapter, String entry, Localization localization) {
        if (entry == null) {
            throw new IllegalArgumentException("An entry must be provided");
        }
        if (this.getFacetHolder().containsFacet(ValueFacet.class)) {
            ObjectAdapter entryAdapter = this.getAdapterManager().adapterFor(entry);
            ParseValueContext parseValueContext = new ParseValueContext(this.deploymentCategory, this.getAuthenticationSessionProvider().getAuthenticationSession(), InteractionInvocationMethod.BY_USER, contextAdapter, this.getIdentified().getIdentifier(), entryAdapter);
            this.validate(parseValueContext);
        }
        Object context = ObjectAdapter.Util.unwrap(contextAdapter);
        this.getDependencyInjector().injectServicesInto(this.parser);
        try {
            Object parsed = this.parser.parseTextEntry(context, entry, localization);
            if (parsed == null) {
                return null;
            }
            ObjectAdapter adapter = this.getAdapterManager().adapterFor(parsed);
            ObjectSpecification specification = adapter.getSpecification();
            ObjectValidityContext validateContext = specification.createValidityInteractionContext(this.deploymentCategory, this.getAuthenticationSessionProvider().getAuthenticationSession(), InteractionInvocationMethod.BY_USER, adapter);
            this.validate(validateContext);
            return adapter;
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException(e.getMessage(), e);
        }
        catch (IllegalFormatException e) {
            throw new TextEntryParseException(e.getMessage(), e);
        }
        catch (ParsingException e) {
            throw new TextEntryParseException(e.getMessage(), e);
        }
    }

    private void validate(ValidityContext<?> validityContext) {
        InteractionResultSet resultSet = new InteractionResultSet();
        InteractionUtils.isValidResultSet(this.getFacetHolder(), validityContext, resultSet);
        if (resultSet.isVetoed()) {
            throw new IllegalArgumentException(resultSet.getInteractionResult().getReason());
        }
    }

    @Override
    public String parseableTitle(ObjectAdapter contextAdapter) {
        Object pojo = ObjectAdapter.Util.unwrap(contextAdapter);
        this.getDependencyInjector().injectServicesInto(this.parser);
        return this.parser.parseableTitleOf(pojo);
    }

    public ServicesInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

