/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.ignore.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;

public class RemovePostConstructOrPreDestroyAnnotationMethodsFacetFactory
extends FacetFactoryAbstract {
    public RemovePostConstructOrPreDestroyAnnotationMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        this.removeIgnoredMethods(processClassContext.getCls(), processClassContext);
    }

    private void removeIgnoredMethods(Class<?> cls, MethodRemover methodRemover) {
        Method[] methods;
        if (cls == null) {
            return;
        }
        for (Method method : methods = cls.getMethods()) {
            RemovePostConstructOrPreDestroyAnnotationMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, PreDestroy.class);
            RemovePostConstructOrPreDestroyAnnotationMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, PostConstruct.class);
        }
    }

    private static <T extends Annotation> void removeAnnotatedMethods(MethodRemover methodRemover, Method method, Class<T> annotationClass) {
        if (!Annotations.isAnnotationPresent(method, annotationClass)) {
            return;
        }
        methodRemover.removeMethod(method);
    }
}

