/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.encodeable.annotcfg;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Encodable;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncoderDecoderUtil;
import org.apache.isis.core.metamodel.facets.object.encodeable.annotcfg.EncodableFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.encodeable.annotcfg.EncodableFacetFromConfiguration;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class EncodableFacetAnnotationElseConfigurationFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware,
ServicesInjectorAware,
AdapterManagerAware {
    private IsisConfiguration configuration;
    private AdapterManager adapterManager;
    private ServicesInjector servicesInjector;

    public EncodableFacetAnnotationElseConfigurationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet(this.create(processClassContaxt.getCls(), (FacetHolder)processClassContaxt.getFacetHolder()));
    }

    private EncodableFacet create(Class<?> cls, FacetHolder holder) {
        EncodableFacetFromConfiguration facet;
        EncodableFacetAnnotation facet2;
        Encodable annotation = Annotations.getAnnotation(cls, Encodable.class);
        if (annotation != null && (facet2 = new EncodableFacetAnnotation(cls, this.getIsisConfiguration(), holder, this.adapterManager, this.servicesInjector)).isValid()) {
            return facet2;
        }
        String encoderDecoderName = EncoderDecoderUtil.encoderDecoderNameFromConfiguration(cls, this.getIsisConfiguration());
        if (!Strings.isNullOrEmpty((String)encoderDecoderName) && (facet = new EncodableFacetFromConfiguration(encoderDecoderName, holder, this.adapterManager, this.servicesInjector)).isValid()) {
            return facet;
        }
        return null;
    }

    public IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    @Override
    public void setServicesInjector(ServicesInjector dependencyInjector) {
        this.servicesInjector = dependencyInjector;
    }
}

