/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.encodeable;

import com.google.common.base.Strings;
import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class EncoderDecoderUtil {
    public static final String ENCODER_DECODER_NAME_KEY_PREFIX = "isis.reflector.java.facets.encoderDecoder.";
    public static final String ENCODER_DECODER_NAME_KEY_SUFFIX = ".encoderDecoderName";

    private EncoderDecoderUtil() {
    }

    public static String encoderDecoderNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = ENCODER_DECODER_NAME_KEY_PREFIX + type.getCanonicalName() + ENCODER_DECODER_NAME_KEY_SUFFIX;
        String encoderDecoderName = configuration.getString(key);
        return !Strings.isNullOrEmpty((String)encoderDecoderName) ? encoderDecoderName : null;
    }

    public static Class<?> encoderDecoderOrNull(Class<?> candidateClass, String classCandidateName) {
        Class<?> type = candidateClass != null ? ClassUtil.implementingClassOrNull(candidateClass.getName(), EncoderDecoder.class, FacetHolder.class) : null;
        return type != null ? type : ClassUtil.implementingClassOrNull(classCandidateName, EncoderDecoder.class, FacetHolder.class);
    }
}

