/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainservicelayout;

import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.NamedFacetForDomainServiceLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.annotation.DomainServiceLayoutFacetAnnotation;

public class DomainServiceLayoutFactory
extends FacetFactoryAbstract {
    public DomainServiceLayoutFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        DomainService domainService = Annotations.getAnnotation(cls, DomainService.class);
        DomainServiceLayout domainServiceLayout = Annotations.getAnnotation(cls, DomainServiceLayout.class);
        if (domainService == null && domainServiceLayout == null) {
            return;
        }
        String domainServiceMenuOrder = domainService != null && !domainService.menuOrder().equals("2147483647") ? domainService.menuOrder() : null;
        String domainServiceLayoutMenuOrder = domainServiceLayout != null && !domainServiceLayout.menuOrder().equals("2147483647") ? domainServiceLayout.menuOrder() : null;
        String menuOrder = DomainServiceLayoutFactory.coalesce(domainServiceLayoutMenuOrder, domainServiceMenuOrder);
        DomainServiceLayout.MenuBar menuBar = domainServiceLayout != null ? domainServiceLayout.menuBar() : DomainServiceLayout.MenuBar.PRIMARY;
        FacetUtil.addFacet(new DomainServiceLayoutFacetAnnotation((FacetHolder)facetHolder, menuBar, menuOrder));
        FacetUtil.addFacet(NamedFacetForDomainServiceLayoutAnnotation.create(domainServiceLayout, facetHolder));
    }

    private static String coalesce(String ... reasons) {
        for (String reason : reasons) {
            if (reason == null) continue;
            return reason;
        }
        return null;
    }
}

