/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.ViewModelLayout;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.BookmarkPolicyFacetForDomainObjectLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.BookmarkPolicyFacetForViewModelLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.CssClassFaFacetForDomainObjectLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.CssClassFaFacetForViewModelLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.CssClassFacetForDomainObjectLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.CssClassFacetForViewModelLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.DescribedAsFacetForDomainObjectLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.DescribedAsFacetForViewModelLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.NamedFacetForDomainObjectLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.NamedFacetForViewModelLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.PagedFacetForDomainObjectLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.PagedFacetForViewModelLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.PluralFacetForDomainObjectLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.PluralFacetForViewModelLayoutAnnotation;

public class DomainObjectLayoutFacetFactory
extends FacetFactoryAbstract {
    public DomainObjectLayoutFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        DomainObjectLayout domainObjectLayout = Annotations.getAnnotation(cls, DomainObjectLayout.class);
        ViewModelLayout viewModelLayout = Annotations.getAnnotation(cls, ViewModelLayout.class);
        FacetUtil.addFacet(CssClassFacetForDomainObjectLayoutAnnotation.create(domainObjectLayout, facetHolder));
        FacetUtil.addFacet(CssClassFacetForViewModelLayoutAnnotation.create(viewModelLayout, facetHolder));
        FacetUtil.addFacet(CssClassFaFacetForDomainObjectLayoutAnnotation.create(domainObjectLayout, facetHolder));
        FacetUtil.addFacet(CssClassFaFacetForViewModelLayoutAnnotation.create(viewModelLayout, facetHolder));
        FacetUtil.addFacet(DescribedAsFacetForDomainObjectLayoutAnnotation.create(domainObjectLayout, facetHolder));
        FacetUtil.addFacet(DescribedAsFacetForViewModelLayoutAnnotation.create(viewModelLayout, facetHolder));
        FacetUtil.addFacet(NamedFacetForDomainObjectLayoutAnnotation.create(domainObjectLayout, facetHolder));
        FacetUtil.addFacet(NamedFacetForViewModelLayoutAnnotation.create(viewModelLayout, facetHolder));
        FacetUtil.addFacet(PagedFacetForDomainObjectLayoutAnnotation.create(domainObjectLayout, facetHolder));
        FacetUtil.addFacet(PagedFacetForViewModelLayoutAnnotation.create(viewModelLayout, facetHolder));
        FacetUtil.addFacet(PluralFacetForDomainObjectLayoutAnnotation.create(domainObjectLayout, facetHolder));
        FacetUtil.addFacet(PluralFacetForViewModelLayoutAnnotation.create(viewModelLayout, facetHolder));
        FacetUtil.addFacet(BookmarkPolicyFacetForDomainObjectLayoutAnnotation.create(domainObjectLayout, facetHolder));
        FacetUtil.addFacet(BookmarkPolicyFacetForViewModelLayoutAnnotation.create(viewModelLayout, facetHolder));
    }
}

