/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.recreatable;

import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetDeclarativeAbstract;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public class RecreatableObjectFacetForDomainObjectAnnotation
extends RecreatableObjectFacetDeclarativeAbstract {
    public static ViewModelFacet create(DomainObject domainObject, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector, FacetHolder holder) {
        if (domainObject == null) {
            return null;
        }
        Nature nature = domainObject.nature();
        if (nature == null || nature == Nature.JDO_ENTITY) {
            return null;
        }
        switch (nature) {
            case NOT_SPECIFIED: 
            case JDO_ENTITY: {
                return null;
            }
            case VIEW_MODEL: {
                ViewModelFacet existingFacet = holder.getFacet(ViewModelFacet.class);
                if (existingFacet != null && existingFacet.getArchitecturalLayer() == ViewModelFacet.ArchitecturalLayer.APPLICATION) {
                    return null;
                }
                return new RecreatableObjectFacetForDomainObjectAnnotation(holder, ViewModelFacet.ArchitecturalLayer.APPLICATION, specificationLoader, adapterManager, servicesInjector);
            }
            case EXTERNAL_ENTITY: 
            case INMEMORY_ENTITY: {
                return new RecreatableObjectFacetForDomainObjectAnnotation(holder, ViewModelFacet.ArchitecturalLayer.DOMAIN, specificationLoader, adapterManager, servicesInjector);
            }
        }
        throw new IllegalArgumentException("nature of '" + nature + "' not recognized");
    }

    private RecreatableObjectFacetForDomainObjectAnnotation(FacetHolder holder, ViewModelFacet.ArchitecturalLayer architecturalLayer, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector) {
        super(holder, architecturalLayer, specificationLoader, adapterManager, servicesInjector);
    }
}

