/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.autocomplete;

import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacetAbstract;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public class AutoCompleteFacetForDomainObjectAnnotation
extends AutoCompleteFacetAbstract {
    private final Class<?> repositoryClass;
    private final String actionName;

    public static AutoCompleteFacet create(DomainObject domainObject, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector, FacetHolder holder) {
        if (domainObject == null) {
            return null;
        }
        Class autoCompleteRepository = domainObject.autoCompleteRepository();
        if (autoCompleteRepository == null || autoCompleteRepository == Object.class) {
            return null;
        }
        String autoCompleteAction = domainObject.autoCompleteAction();
        return new AutoCompleteFacetForDomainObjectAnnotation(holder, autoCompleteRepository, autoCompleteAction, specificationLoader, adapterManager, servicesInjector);
    }

    private AutoCompleteFacetForDomainObjectAnnotation(FacetHolder holder, Class<?> repositoryClass, String actionName, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector) {
        super(holder, repositoryClass, actionName, specificationLoader, adapterManager, servicesInjector);
        this.repositoryClass = repositoryClass;
        this.actionName = actionName;
    }

    public Class<?> getRepositoryClass() {
        return this.repositoryClass;
    }

    public String getActionName() {
        return this.actionName;
    }
}

