/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.dirty.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.dirty.method.ClearDirtyObjectFacetViaMethod;
import org.apache.isis.core.metamodel.facets.object.dirty.method.IsDirtyObjectFacetViaMethod;
import org.apache.isis.core.metamodel.facets.object.dirty.method.MarkDirtyObjectFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class DirtyMethodsFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String MARK_DIRTY_PREFIX = "markDirty";
    private static final String CLEAR_DIRTY_PREFIX = "clearDirty";
    private static final String IS_DIRTY_PREFIX = "isDirty";
    private static final String[] PREFIXES = new String[]{"markDirty", "clearDirty", "isDirty"};

    public DirtyMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Object facetHolder = processClassContext.getFacetHolder();
        Class<?> cls = processClassContext.getCls();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, IS_DIRTY_PREFIX, Boolean.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            processClassContext.removeMethod(method);
            facets.add(new IsDirtyObjectFacetViaMethod(method, (FacetHolder)facetHolder));
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, CLEAR_DIRTY_PREFIX, Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            processClassContext.removeMethod(method);
            facets.add(new ClearDirtyObjectFacetViaMethod(method, (FacetHolder)facetHolder));
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, MARK_DIRTY_PREFIX, Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            processClassContext.removeMethod(method);
            facets.add(new MarkDirtyObjectFacetViaMethod(method, (FacetHolder)facetHolder));
        }
        FacetUtil.addFacets(facets);
    }
}

