/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks.load;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.callbacks.load.LoadedCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.facets.object.callbacks.load.LoadingCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class LoadCallbackFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"loaded", "loading"};

    public LoadCallbackFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        ArrayList<Method> methods = new ArrayList<Method>();
        Method method = null;
        method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "loading", Void.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            methods.add(method);
            facets.add(new LoadingCallbackFacetViaMethod(method, (FacetHolder)facetHolder));
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "loaded", Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            methods.add(method);
            facets.add(new LoadedCallbackFacetViaMethod(method, (FacetHolder)facetHolder));
        }
        processClassContext.removeMethods(methods);
        FacetUtil.addFacets(facets);
    }
}

