/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.render.annotprop;

import java.util.Properties;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.applib.annotation.Resolve;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.render.RenderFacet;
import org.apache.isis.core.metamodel.facets.members.render.annotprop.RenderFacetAnnotation;
import org.apache.isis.core.metamodel.facets.members.render.annotprop.RenderFacetProperties;
import org.apache.isis.core.metamodel.facets.members.render.annotprop.RenderFacetViaResolveAnnotation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class RenderFacetOrResolveFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
MetaModelValidatorRefiner,
IsisConfigurationAware {
    private final MetaModelValidatorForDeprecatedAnnotation renderValidator = new MetaModelValidatorForDeprecatedAnnotation(Render.class);
    private final MetaModelValidatorForDeprecatedAnnotation resolveValidator = new MetaModelValidatorForDeprecatedAnnotation(Resolve.class);

    public RenderFacetOrResolveFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        RenderFacet renderFacet = RenderFacetOrResolveFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (renderFacet == null) {
            renderFacet = this.renderValidator.flagIfPresent(RenderFacetOrResolveFactory.createFromRenderAnnotationIfPossible(processMethodContext), processMethodContext);
        }
        if (renderFacet == null) {
            renderFacet = this.resolveValidator.flagIfPresent(RenderFacetOrResolveFactory.createFromResolveAnnotationIfPossible(processMethodContext), processMethodContext);
        }
        FacetUtil.addFacet(renderFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        RenderFacet renderFacet = RenderFacetOrResolveFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(renderFacet);
    }

    private static RenderFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("render");
        return properties != null ? new RenderFacetProperties(properties, holder) : null;
    }

    private static RenderFacet createFromRenderAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Render renderAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Render.class);
        return renderAnnotation == null ? null : new RenderFacetAnnotation((FacetHolder)processMethodContext.getFacetHolder(), renderAnnotation.value());
    }

    private static RenderFacet createFromResolveAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Resolve resolveAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Resolve.class);
        return resolveAnnotation == null ? null : new RenderFacetViaResolveAnnotation((FacetHolder)processMethodContext.getFacetHolder(), resolveAnnotation.value());
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.renderValidator);
        metaModelValidator.add(this.resolveValidator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.renderValidator.setConfiguration(configuration);
        this.resolveValidator.setConfiguration(configuration);
    }
}

