/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.order;

import com.google.common.base.Strings;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.MultipleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;

public abstract class MemberOrderFacetAbstract
extends MultipleValueFacetAbstract
implements MemberOrderFacet {
    private final String name;
    private final String sequence;
    private final TranslationService translationService;

    public static Class<? extends Facet> type() {
        return MemberOrderFacet.class;
    }

    public MemberOrderFacetAbstract(String name, String sequence, TranslationService translationService, FacetHolder holder) {
        super(MemberOrderFacetAbstract.type(), holder);
        this.translationService = translationService;
        this.name = this.translatedValueElse(name, "");
        this.sequence = MemberOrderFacetAbstract.valueElse(sequence, "1");
    }

    private String translatedValueElse(String name, String defaultValue) {
        boolean nullOrEmpty = Strings.isNullOrEmpty((String)name);
        if (nullOrEmpty) {
            return defaultValue;
        }
        IdentifiedHolder identifiedHolder = (IdentifiedHolder)this.getFacetHolder();
        String context = identifiedHolder.getIdentifier().getClassName();
        return this.translationService.translate(context, name);
    }

    private static String valueElse(String name, String defaultValue) {
        boolean nullOrEmpty = Strings.isNullOrEmpty((String)name);
        if (nullOrEmpty) {
            return defaultValue;
        }
        return name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String sequence() {
        return this.sequence;
    }
}

