/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.named.annotprop;

import java.util.Properties;
import org.apache.isis.applib.annotation.Named;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.named.annotprop.NamedFacetOnMemberAnnotation;
import org.apache.isis.core.metamodel.facets.members.named.annotprop.NamedFacetOnMemberFromProperties;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class NamedFacetOnMemberFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
MetaModelValidatorRefiner,
IsisConfigurationAware {
    private final MetaModelValidatorForDeprecatedAnnotation namedValidator = new MetaModelValidatorForDeprecatedAnnotation(Named.class);

    public NamedFacetOnMemberFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        NamedFacet namedFacet = NamedFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (namedFacet == null) {
            namedFacet = this.namedValidator.flagIfPresent(NamedFacetOnMemberFactory.createFromAnnotationIfPossible(processMethodContext), processMethodContext);
        }
        FacetUtil.addFacet(namedFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        NamedFacet namedFacet = NamedFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(namedFacet);
    }

    private static NamedFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("named");
        return properties != null ? new NamedFacetOnMemberFromProperties(properties, holder) : null;
    }

    private static NamedFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Named annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Named.class);
        return annotation != null ? new NamedFacetOnMemberAnnotation(annotation.value(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.namedValidator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.namedValidator.setConfiguration(configuration);
    }
}

