/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.hidden.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.hidden.staticmethod.HiddenFacetOnStaticMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedMethodPrefix;

@Deprecated
public class HiddenFacetStaticMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements MetaModelValidatorRefiner,
IsisConfigurationAware {
    private static final String[] PREFIXES = new String[]{"alwaysHide"};
    private final MetaModelValidatorForDeprecatedMethodPrefix validator = new MetaModelValidatorForDeprecatedMethodPrefix(PREFIXES[0]);

    public HiddenFacetStaticMethodFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachHiddenFacetIfAlwaysHideMethodIsFound(processMethodContext);
    }

    public void attachHiddenFacetIfAlwaysHideMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> type = processMethodContext.getCls();
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Method alwaysHideMethod = MethodFinderUtils.findMethod(type, MethodScope.CLASS, "alwaysHide" + capitalizedName, Boolean.TYPE, new Class[0]);
        if (alwaysHideMethod == null) {
            return;
        }
        processMethodContext.removeMethod(alwaysHideMethod);
        Boolean alwaysHideMethodReturnValue = HiddenFacetStaticMethodFactory.invokeAlwaysHideMethod(alwaysHideMethod);
        if (!alwaysHideMethodReturnValue.booleanValue()) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        HiddenFacetOnStaticMethod facet = new HiddenFacetOnStaticMethod((FacetHolder)facetedMethod);
        FacetUtil.addFacet(this.validator.flagIfPresent(facet, processMethodContext));
    }

    private static Boolean invokeAlwaysHideMethod(Method alwaysHideMethod) {
        Boolean alwaysHideMethodReturnValue = null;
        try {
            alwaysHideMethodReturnValue = (Boolean)MethodExtensions.invokeStatic(alwaysHideMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (alwaysHideMethodReturnValue == null) {
            throw new MetaModelException("method " + alwaysHideMethod + "must return a boolean");
        }
        return alwaysHideMethodReturnValue;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.validator.setConfiguration(configuration);
    }
}

