/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.hidden.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.hidden.method.HideForContextFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class HideForContextFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"hide"};

    public HideForContextFacetViaMethodFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        HideForContextFacetViaMethodFactory.attachHideFacetIfHideMethodIsFound(processMethodContext);
    }

    public static void attachHideFacetIfHideMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(getMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Method hideMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "hide" + capitalizedName, Boolean.TYPE, new Class[0]);
        if (hideMethod == null && (hideMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "hide" + capitalizedName, Boolean.TYPE, getMethod.getParameterTypes())) == null) {
            return;
        }
        processMethodContext.removeMethod(hideMethod);
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new HideForContextFacetViaMethod(hideMethod, (FacetHolder)facetedMethod));
    }
}

