/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.hidden.forsession;

import java.lang.reflect.Method;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.hidden.forsession.HideForSessionFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class HideForSessionFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"hide"};

    public HideForSessionFacetViaMethodFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        HideForSessionFacetViaMethodFactory.attachHideFacetIfHideMethodForSessionIsFound(processMethodContext);
    }

    public static void attachHideFacetIfHideMethodForSessionIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method hideForSessionMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "hide" + capitalizedName, Boolean.TYPE, new Class[]{UserMemento.class});
        if (hideForSessionMethod == null) {
            return;
        }
        processMethodContext.removeMethod(hideForSessionMethod);
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new HideForSessionFacetViaMethod(hideForSessionMethod, (FacetHolder)facetedMethod));
    }
}

