/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.disabled.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.disabled.staticmethod.DisabledFacetForStaticMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedMethodPrefix;

@Deprecated
public class DisabledFacetStaticMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements MetaModelValidatorRefiner,
IsisConfigurationAware {
    private static final String[] PREFIXES = new String[]{"protect"};
    private final MetaModelValidatorForDeprecatedMethodPrefix validator = new MetaModelValidatorForDeprecatedMethodPrefix(PREFIXES[0]);

    public DisabledFacetStaticMethodFacetFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachDisabledFacetIfProtectMethodIsFound(processMethodContext);
    }

    public void attachDisabledFacetIfProtectMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Class[] paramTypes = new Class[]{};
        Class<?> type = processMethodContext.getCls();
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Method protectMethod = MethodFinderUtils.findMethodWithOrWithoutParameters(type, MethodScope.CLASS, "protect" + capitalizedName, Boolean.TYPE, paramTypes);
        if (protectMethod == null) {
            return;
        }
        processMethodContext.removeMethod(protectMethod);
        Boolean protectMethodReturnValue = DisabledFacetStaticMethodFacetFactory.invokeProtectMethod(protectMethod);
        if (!protectMethodReturnValue.booleanValue()) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        DisabledFacetForStaticMethod facet = new DisabledFacetForStaticMethod((FacetHolder)facetedMethod);
        FacetUtil.addFacet(this.validator.flagIfPresent(facet, processMethodContext));
    }

    private static Boolean invokeProtectMethod(Method protectMethod) {
        Boolean protectMethodReturnValue = null;
        try {
            protectMethodReturnValue = (Boolean)MethodExtensions.invokeStatic(protectMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (protectMethodReturnValue == null) {
            throw new MetaModelException("method " + protectMethod + "must return a boolean");
        }
        return protectMethodReturnValue;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.validator.setConfiguration(configuration);
    }
}

