/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.disabled.method;

import java.lang.reflect.Method;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.disabled.method.DisableForContextFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;

public class DisableForContextFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements ServicesInjectorAware {
    private static final String[] PREFIXES = new String[]{"disable"};
    private ServicesInjector servicesInjector;

    public DisableForContextFacetViaMethodFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachDisabledFacetIfDisabledMethodIsFound(processMethodContext);
    }

    private void attachDisabledFacetIfDisabledMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method disableMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "disable" + capitalizedName, new Class[]{String.class, TranslatableString.class}, method.getParameterTypes());
        if (disableMethod == null) {
            return;
        }
        processMethodContext.removeMethod(disableMethod);
        Object facetHolder = processMethodContext.getFacetHolder();
        TranslationService translationService = this.servicesInjector.lookupService(TranslationService.class);
        String translationContext = ((IdentifiedHolder)facetHolder).getIdentifier().toClassAndNameIdentityString();
        FacetUtil.addFacet(new DisableForContextFacetViaMethod(disableMethod, translationService, translationContext, (FacetHolder)facetHolder));
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

