/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.invocation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.ViewModel;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.annotation.InvokedOn;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.actinvoc.ActionInvocationContext;
import org.apache.isis.applib.services.background.ActionInvocationMemento;
import org.apache.isis.applib.services.background.BackgroundService;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ThrowableExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.ElementSpecificationProviderFromTypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.bulk.BulkFacet;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.ReflectiveActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionInvocationFacetForDomainEventAbstract
extends ActionInvocationFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = LoggerFactory.getLogger(ActionInvocationFacetForDomainEventAbstract.class);
    private final Method method;
    private final ObjectSpecification onType;
    private final ObjectSpecification returnType;
    private final AdapterManager adapterManager;
    private final RuntimeContext runtimeContext;
    private final ServicesInjector servicesInjector;
    private final IsisConfiguration configuration;
    private final Class<? extends ActionDomainEvent<?>> eventType;
    private final DomainEventHelper domainEventHelper;

    public ActionInvocationFacetForDomainEventAbstract(Class<? extends ActionDomainEvent<?>> eventType, Method method, ObjectSpecification onType, ObjectSpecification returnType, FacetHolder holder, RuntimeContext runtimeContext, AdapterManager adapterManager, ServicesInjector servicesInjector, IsisConfiguration configuration) {
        super(holder);
        this.eventType = eventType;
        this.method = method;
        this.onType = onType;
        this.returnType = returnType;
        this.runtimeContext = runtimeContext;
        this.adapterManager = adapterManager;
        this.servicesInjector = servicesInjector;
        this.configuration = configuration;
        this.domainEventHelper = new DomainEventHelper(this.servicesInjector);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.EXECUTE;
    }

    @Override
    public ObjectSpecification getReturnType() {
        return this.returnType;
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.onType;
    }

    @Override
    public ObjectAdapter invoke(ObjectAdapter targetAdapter, ObjectAdapter[] argumentAdapters, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        return this.invoke(null, targetAdapter, argumentAdapters, authenticationSession, deploymentCategory);
    }

    @Override
    public ObjectAdapter invoke(ObjectAction owningAction, ObjectAdapter targetAdapter, ObjectAdapter[] arguments, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        CommandContext commandContext = this.getServicesInjector().lookupService(CommandContext.class);
        Command command = commandContext != null ? commandContext.getCommand() : null;
        ActionDomainEvent<?> event = this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.EXECUTING, this.eventType, null, owningAction, targetAdapter, arguments, command, null);
        InvocationResult invocationResult = this.internalInvoke(command, owningAction, targetAdapter, arguments);
        ObjectAdapter invocationResultAdapter = invocationResult.getAdapter();
        if (invocationResult.getWhetherInvoked()) {
            this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.EXECUTED, this.eventType, this.verify(event), owningAction, targetAdapter, arguments, command, invocationResultAdapter);
        }
        if (invocationResultAdapter == null) {
            return null;
        }
        boolean filterForVisibility = this.getConfiguration().getBoolean("isis.reflector.facet.actionInvocation.filterVisibility", true);
        if (filterForVisibility) {
            Object result = invocationResultAdapter.getObject();
            if (result instanceof Collection || result.getClass().isArray()) {
                CollectionFacet facet = CollectionFacet.Utils.getCollectionFacetFromSpec(invocationResultAdapter);
                Iterable<ObjectAdapter> adapterList = facet.iterable(invocationResultAdapter);
                List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(adapterList, authenticationSession, deploymentCategory);
                Object visibleObjects = CollectionUtils.copyOf(Lists.transform(visibleAdapters, ObjectAdapter.Functions.getObject()), this.method.getReturnType());
                if (visibleObjects != null) {
                    return this.getAdapterManager().adapterFor(visibleObjects);
                }
            } else {
                boolean visible = ObjectAdapter.Util.isVisible(invocationResultAdapter, authenticationSession, deploymentCategory);
                if (!visible) {
                    return null;
                }
            }
        }
        return invocationResultAdapter;
    }

    protected ActionDomainEvent<?> verify(ActionDomainEvent<?> event) {
        return event;
    }

    public Class<? extends ActionDomainEvent<?>> getEventType() {
        return this.eventType;
    }

    protected InvocationResult internalInvoke(Command command, ObjectAction owningAction, ObjectAdapter targetAdapter, ObjectAdapter[] arguments) {
        try {
            PublishedActionFacet publishedActionFacet;
            Object result;
            ActionSemanticsFacet semanticsFacet;
            boolean cacheable;
            final Object[] executionParameters = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                executionParameters[i] = ActionInvocationFacetForDomainEventAbstract.unwrap(arguments[i]);
            }
            final Object targetPojo = ActionInvocationFacetForDomainEventAbstract.unwrap(targetAdapter);
            BulkFacet bulkFacet = this.getFacetHolder().getFacet(BulkFacet.class);
            if (bulkFacet != null) {
                Bulk.InteractionContext bulkInteractionContext;
                ActionInvocationContext actionInvocationContext = this.getServicesInjector().lookupService(ActionInvocationContext.class);
                if (actionInvocationContext != null && actionInvocationContext.getInvokedOn() == null) {
                    actionInvocationContext.setInvokedOn(InvokedOn.OBJECT);
                    actionInvocationContext.setDomainObjects(Collections.singletonList(targetPojo));
                }
                if ((bulkInteractionContext = this.getServicesInjector().lookupService(Bulk.InteractionContext.class)) != null && bulkInteractionContext.getInvokedAs() == null) {
                    bulkInteractionContext.setInvokedAs(Bulk.InteractionContext.InvokedAs.REGULAR);
                    actionInvocationContext.setDomainObjects(Collections.singletonList(targetPojo));
                }
            }
            if (command != null && command.getExecutor() == Command.Executor.USER && owningAction != null) {
                if (command.getTarget() == null) {
                    command.setTargetClass(CommandUtil.targetClassNameFor(targetAdapter));
                    command.setTargetAction(CommandUtil.targetActionNameFor(owningAction));
                    command.setArguments(CommandUtil.argDescriptionFor(owningAction, arguments));
                    Bookmark targetBookmark = CommandUtil.bookmarkFor(targetAdapter);
                    command.setTarget(targetBookmark);
                }
                if (!"(edit)".equals(command.getMemberIdentifier())) {
                    command.setMemberIdentifier(CommandUtil.actionIdentifierFor(owningAction));
                    BackgroundService backgroundService = this.getServicesInjector().lookupService(BackgroundService.class);
                    if (backgroundService != null) {
                        Object[] args;
                        Object targetObject = ActionInvocationFacetForDomainEventAbstract.unwrap(targetAdapter);
                        ActionInvocationMemento aim = backgroundService.asActionInvocationMemento(this.method, targetObject, args = CommandUtil.objectsFor(arguments));
                        if (aim != null) {
                            command.setMemento(aim.asMementoString());
                        } else {
                            throw new IsisException("Unable to build memento for action " + owningAction.getIdentifier().toClassAndNameIdentityString());
                        }
                    }
                }
                CommandFacet commandFacet = this.getFacetHolder().getFacet(CommandFacet.class);
                if (commandFacet != null && !commandFacet.isDisabled()) {
                    command.setExecuteIn(commandFacet.executeIn());
                    command.setPersistence(commandFacet.persistence());
                } else {
                    command.setExecuteIn(Command.ExecuteIn.FOREGROUND);
                    command.setPersistence(Command.Persistence.IF_HINTED);
                }
            }
            if (command != null && command.getExecutor() == Command.Executor.USER && command.getExecuteIn() == Command.ExecuteIn.BACKGROUND) {
                CommandService commandService = this.getServicesInjector().lookupService(CommandService.class);
                if (commandService.persistIfPossible(command)) {
                    ObjectAdapter resultAdapter = this.getAdapterManager().adapterFor(command);
                    return InvocationResult.forActionThatReturned(resultAdapter);
                }
                throw new IsisException("Unable to schedule action '" + owningAction.getIdentifier().toClassAndNameIdentityString() + "' to run in background: " + "CommandService does not support persistent commands ");
            }
            if (command != null) {
                command.setStartedAt(Clock.getTimeAsJavaSqlTimestamp());
            }
            boolean bl = cacheable = (semanticsFacet = this.getFacetHolder().getFacet(ActionSemanticsFacet.class)) != null && ((ActionSemantics.Of)semanticsFacet.value()).isSafeAndRequestCacheable();
            if (cacheable) {
                QueryResultsCache queryResultsCache = this.getServicesInjector().lookupService(QueryResultsCache.class);
                result = queryResultsCache.execute((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ActionInvocationFacetForDomainEventAbstract.this.method.invoke(targetPojo, executionParameters);
                    }
                }, targetPojo.getClass(), this.method.getName(), executionParameters);
            } else {
                result = this.method.invoke(targetPojo, executionParameters);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(" action result " + result);
            }
            if (result == null) {
                if (targetAdapter.getSpecification().isViewModelCloneable(targetAdapter)) {
                    ViewModel.Cloneable cloneable = (ViewModel.Cloneable)targetAdapter.getObject();
                    Object clone = cloneable.clone();
                    ObjectAdapter clonedAdapter = this.getAdapterManager().adapterFor(clone);
                    return InvocationResult.forActionThatReturned(clonedAdapter);
                }
                return InvocationResult.forActionThatReturned(null);
            }
            ObjectAdapter resultAdapter = this.getAdapterManager().adapterFor(result);
            if (resultAdapter.getSpecification().isViewModelCloneable(resultAdapter)) {
                ViewModel.Cloneable cloneable = (ViewModel.Cloneable)result;
                result = cloneable.clone();
                resultAdapter = this.getAdapterManager().adapterFor(result);
            }
            TypeOfFacet typeOfFacet = this.getFacetHolder().getFacet(TypeOfFacet.class);
            resultAdapter.setElementSpecificationProvider(ElementSpecificationProviderFromTypeOfFacet.createFrom(typeOfFacet));
            if (command != null && !resultAdapter.getSpecification().containsDoOpFacet(ViewModelFacet.class)) {
                Bookmark bookmark = CommandUtil.bookmarkFor(resultAdapter);
                command.setResult(bookmark);
            }
            currentInvocation.set((publishedActionFacet = this.getIdentified().getFacet(PublishedActionFacet.class)) != null ? new ActionInvocationFacet.CurrentInvocation(targetAdapter, this.getIdentified(), arguments, resultAdapter, command) : null);
            return InvocationResult.forActionThatReturned(resultAdapter);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IllegalStateException) {
                throw new ReflectiveActionException("IllegalStateException thrown while executing " + this.method + " " + targetException.getMessage(), targetException);
            }
            if (targetException instanceof RecoverableException && !this.runtimeContext.getTransactionState().canCommit()) {
                Throwable targetExceptionCause = targetException.getCause();
                Throwable nonRecoverableCause = targetExceptionCause != null ? targetExceptionCause : targetException;
                String message = nonRecoverableCause.getMessage();
                if (!Strings.isNullOrEmpty((String)message) && (message = message.substring(0, Math.min(message.length(), 300))).length() == 300) {
                    message = message + " ...";
                }
                throw new NonRecoverableException(message, nonRecoverableCause);
            }
            ThrowableExtensions.throwWithinIsisException(e, "Exception executing " + this.method);
            return InvocationResult.forActionNotInvoked();
        }
        catch (IllegalAccessException e) {
            throw new ReflectiveActionException("Illegal access of " + this.method, e);
        }
    }

    private static Object unwrap(ObjectAdapter adapter) {
        return adapter == null ? null : adapter.getObject();
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public static class InvocationResult {
        private final boolean whetherInvoked;
        private final ObjectAdapter adapter;

        public static InvocationResult forActionThatReturned(ObjectAdapter resultAdapter) {
            return new InvocationResult(true, resultAdapter);
        }

        public static InvocationResult forActionNotInvoked() {
            return new InvocationResult(false, null);
        }

        private InvocationResult(boolean whetherInvoked, ObjectAdapter result) {
            this.whetherInvoked = whetherInvoked;
            this.adapter = result;
        }

        public boolean getWhetherInvoked() {
            return this.whetherInvoked;
        }

        public ObjectAdapter getAdapter() {
            return this.adapter;
        }
    }
}

