/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.invocation;

import java.util.Map;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacet;
import org.apache.isis.core.metamodel.interactions.ActionInvocationContext;
import org.apache.isis.core.metamodel.interactions.InteractionContext;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public abstract class ActionDomainEventFacetAbstract
extends SingleClassValueFacetAbstract
implements ActionDomainEventFacet {
    private final TranslationService translationService;
    private final String translationContext;
    private final DomainEventHelper domainEventHelper;

    static Class<? extends Facet> type() {
        return ActionDomainEventFacet.class;
    }

    public ActionDomainEventFacetAbstract(Class<? extends ActionDomainEvent<?>> eventType, FacetHolder holder, ServicesInjector servicesInjector, SpecificationLoader specificationLoader) {
        super(ActionDomainEventFacetAbstract.type(), holder, eventType, specificationLoader);
        this.translationService = servicesInjector.lookupService(TranslationService.class);
        this.translationContext = ((IdentifiedHolder)holder).getIdentifier().toClassAndNameIdentityString();
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        if (!this.domainEventHelper.hasEventBusService()) {
            return null;
        }
        ObjectAdapter[] argumentAdapters = ActionDomainEventFacetAbstract.argumentAdaptersFrom(ic);
        ActionDomainEvent<?> event = this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.HIDE, this.eventType(), null, this.getIdentified(), ic.getTarget(), argumentAdapters, null, null);
        if (event != null && event.isHidden()) {
            return "Hidden by subscriber";
        }
        return null;
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        if (!this.domainEventHelper.hasEventBusService()) {
            return null;
        }
        ObjectAdapter[] argumentAdapters = ActionDomainEventFacetAbstract.argumentAdaptersFrom(ic);
        ActionDomainEvent<?> event = this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.DISABLE, this.eventType(), null, this.getIdentified(), ic.getTarget(), argumentAdapters, null, null);
        if (event != null && event.isDisabled()) {
            TranslatableString reasonTranslatable = event.getDisabledReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getDisabledReason();
        }
        return null;
    }

    private static ObjectAdapter[] argumentAdaptersFrom(InteractionContext<? extends InteractionEvent> ic) {
        ObjectAdapter[] objectAdapterArray;
        Map<Integer, ObjectAdapter> contributeeAsMap = ic.getContributeeAsMap();
        if (contributeeAsMap.isEmpty()) {
            objectAdapterArray = null;
        } else {
            ObjectAdapter[] objectAdapterArray2 = new ObjectAdapter[1];
            objectAdapterArray = objectAdapterArray2;
            objectAdapterArray2[0] = contributeeAsMap.get(0);
        }
        return objectAdapterArray;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> ic) {
        if (!this.domainEventHelper.hasEventBusService()) {
            return null;
        }
        ActionInvocationContext aic = (ActionInvocationContext)ic;
        ActionDomainEvent<?> event = this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.VALIDATE, this.eventType(), null, this.getIdentified(), ic.getTarget(), aic.getArgs(), null, null);
        if (event != null && event.isInvalid()) {
            TranslatableString reasonTranslatable = event.getInvalidityReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getInvalidityReason();
        }
        return null;
    }

    protected Class eventType() {
        return this.value();
    }

    public Class<? extends ActionDomainEvent<?>> getEventType() {
        return this.eventType();
    }
}

