/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class Annotations {
    private Annotations() {
    }

    public static boolean isString(Class<?> cls) {
        return cls.equals(String.class);
    }

    public static <T extends Annotation> T getDeclaredAnnotation(Class<?> cls, Class<T> annotationClass) {
        Annotation[] declaredAnnotations = cls.getDeclaredAnnotations();
        if (declaredAnnotations == null) {
            return null;
        }
        for (Annotation annotation : declaredAnnotations) {
            if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return null;
        }
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                T annotationFromSuperclass = Annotations.getAnnotation(superclass, annotationClass);
                if (annotationFromSuperclass != null) {
                    return annotationFromSuperclass;
                }
            }
            catch (SecurityException annotationFromSuperclass) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            T annotationFromInterface = Annotations.getAnnotation(iface, annotationClass);
            if (annotationFromInterface == null) continue;
            return annotationFromInterface;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (method == null) {
            return null;
        }
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.getAnnotation(parentClassMethod, annotationClass);
            }
            catch (SecurityException parentClassMethod) {
            }
            catch (NoSuchMethodException parentClassMethod) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.getAnnotation(ifaceMethod, annotationClass);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        Class<?>[] interfaces;
        if (method == null) {
            return false;
        }
        boolean present = method.isAnnotationPresent(annotationClass);
        if (present) {
            return true;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.isAnnotationPresent(parentClassMethod, annotationClass);
            }
            catch (SecurityException parentClassMethod) {
            }
            catch (NoSuchMethodException parentClassMethod) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.isAnnotationPresent(ifaceMethod, annotationClass);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        Class<?>[] interfaces;
        if (method == null) {
            return new Annotation[0][0];
        }
        Annotation[][] allParamAnnotations = method.getParameterAnnotations();
        boolean foundAnnotationsForAnyParameter = false;
        for (Annotation[] singleParamAnnotations : allParamAnnotations) {
            if (singleParamAnnotations.length <= 0) continue;
            foundAnnotationsForAnyParameter = true;
            break;
        }
        if (foundAnnotationsForAnyParameter) {
            return allParamAnnotations;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.getParameterAnnotations(parentClassMethod);
            }
            catch (SecurityException parentClassMethod) {
            }
            catch (NoSuchMethodException parentClassMethod) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.getParameterAnnotations(ifaceMethod);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return Annotations.noParamAnnotationsFor(method);
    }

    private static Annotation[][] noParamAnnotationsFor(Method method) {
        return new Annotation[method.getParameterTypes().length][0];
    }
}

