/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetdecorator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;

public class FacetDecoratorSet
implements ApplicationScopedComponent {
    private final Map<Class<? extends Facet>, List<FacetDecorator>> facetDecoratorByFacetType = new HashMap<Class<? extends Facet>, List<FacetDecorator>>();
    private final Set<FacetDecorator> facetDecoratorSet = new LinkedHashSet<FacetDecorator>();

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    public void add(FacetDecorator decorator) {
        Class<? extends Facet>[] decoratedFacetTypes;
        for (Class<? extends Facet> decoratedFacetType : decoratedFacetTypes = decorator.getFacetTypes()) {
            this.getFacetDecoratorList(decoratedFacetType).add(decorator);
            this.facetDecoratorSet.add(decorator);
        }
    }

    private List<FacetDecorator> getFacetDecoratorList(Class<? extends Facet> decoratedFacetType) {
        List<FacetDecorator> facetDecoratorList = this.facetDecoratorByFacetType.get(decoratedFacetType);
        if (facetDecoratorList == null) {
            facetDecoratorList = new ArrayList<FacetDecorator>();
            this.facetDecoratorByFacetType.put(decoratedFacetType, facetDecoratorList);
        }
        return facetDecoratorList;
    }

    public void add(List<FacetDecorator> decorators) {
        for (FacetDecorator decorator : decorators) {
            this.add(decorator);
        }
    }

    public Set<FacetDecorator> getFacetDecorators() {
        return Collections.unmodifiableSet(this.facetDecoratorSet);
    }

    public boolean isEmpty() {
        return this.facetDecoratorByFacetType.isEmpty();
    }

    public void decorate(ObjectSpecification holder) {
        this.decorateAllFacets(holder);
        for (ObjectAssociation objectAssociation : holder.getAssociations(Contributed.EXCLUDED)) {
            this.decorateAllFacets(objectAssociation);
        }
        for (ObjectAction objectAction : holder.getObjectActions(Contributed.EXCLUDED)) {
            this.decorateAllFacets(objectAction);
            List<ObjectActionParameter> parameters = objectAction.getParameters();
            for (ObjectActionParameter parameter : parameters) {
                this.decorateAllFacets(parameter);
            }
        }
    }

    private void decorateAllFacets(FacetHolder holder) {
        Class<? extends Facet>[] facetTypes;
        if (this.isEmpty()) {
            return;
        }
        for (Class<? extends Facet> facetType : facetTypes = holder.getFacetTypes()) {
            Facet facet = holder.getFacet(facetType);
            this.decorateFacet(facet, holder);
        }
    }

    private void decorateFacet(Facet facet, FacetHolder requiredHolder) {
        Class<? extends Facet> facetType = facet.facetType();
        Class<? extends Facet> cls = facetType;
        List<FacetDecorator> decoratorList = this.facetDecoratorByFacetType.get(cls);
        if (decoratorList == null) {
            return;
        }
        for (FacetDecorator facetDecorator : decoratorList) {
            Facet decoratingFacet = facetDecorator.decorate(facet, requiredHolder);
            if (decoratingFacet == null) continue;
            FacetDecoratorSet.ensureDecoratorMetContract(facetDecorator, decoratingFacet, facetType, requiredHolder);
        }
    }

    private static void ensureDecoratorMetContract(FacetDecorator facetDecorator, Facet decoratingFacet, Class<? extends Facet> facetType, FacetHolder originalFacetHolder) {
        if (decoratingFacet.facetType() != facetType) {
            throw new MetaModelException(MessageFormat.format("Problem with facet decorator '{0}'; inconsistent decorating facetType() for {1}; was {2} but expectected facetType() of {3}", facetDecorator.getClass().getName(), decoratingFacet.getClass().getName(), decoratingFacet.facetType().getName(), facetType.getName()));
        }
        Facet facetForFacetType = originalFacetHolder.getFacet(decoratingFacet.facetType());
        if (facetForFacetType != decoratingFacet) {
            throw new MetaModelException(MessageFormat.format("Problem with facet decorator '{0}'; has not replaced original facet for facetType() of {1}", facetDecorator.getClass().getName(), facetType.getName()));
        }
    }

    public void debugData(DebugBuilder str) {
        str.appendTitle("Facet decorators");
        Set<Class<? extends Facet>> facetTypes = this.facetDecoratorByFacetType.keySet();
        if (facetTypes.size() == 0) {
            str.append("none");
        } else {
            for (Class<? extends Facet> cls : facetTypes) {
                str.appendln(cls.getName(), this.facetDecoratorByFacetType.get(cls));
            }
        }
    }
}

