/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetapi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;

public final class FacetUtil {
    private FacetUtil() {
    }

    public static boolean addFacet(Facet facet) {
        if (facet == null) {
            return false;
        }
        facet.getFacetHolder().addFacet(facet);
        return true;
    }

    public static boolean addFacet(MultiTypedFacet facet) {
        if (facet == null) {
            return false;
        }
        facet.getFacetHolder().addFacet(facet);
        return true;
    }

    public static boolean addFacets(Facet[] facets) {
        boolean addedFacets = false;
        for (Facet facet : facets) {
            addedFacets = FacetUtil.addFacet(facet) | addedFacets;
        }
        return addedFacets;
    }

    public static boolean addFacets(List<Facet> facetList) {
        boolean addedFacets = false;
        for (Facet facet : facetList) {
            addedFacets = FacetUtil.addFacet(facet) | addedFacets;
        }
        return addedFacets;
    }

    public static Class<? extends Facet>[] getFacetTypes(Map<Class<? extends Facet>, Facet> facetsByClass) {
        return facetsByClass.keySet().toArray(new Class[0]);
    }

    public static List<Facet> getFacets(Map<Class<? extends Facet>, Facet> facetsByClass, Filter<Facet> filter) {
        ArrayList filteredFacets = Lists.newArrayList();
        ArrayList<Facet> allFacets = new ArrayList<Facet>(facetsByClass.values());
        for (Facet facet : allFacets) {
            if (!filter.accept((Object)facet) || filteredFacets.contains(facet)) continue;
            filteredFacets.add(facet);
        }
        return filteredFacets;
    }

    public static void removeFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Facet facet) {
        FacetUtil.removeFacet(facetsByClass, facet.facetType());
    }

    public static void removeFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Class<? extends Facet> facetType) {
        Facet facet = facetsByClass.get(facetType);
        if (facet == null) {
            return;
        }
        facetsByClass.remove(facetType);
        facet.setFacetHolder(null);
    }

    public static void addFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Facet facet) {
        facetsByClass.put(facet.facetType(), facet);
    }

    public static Facet[] toArray(List<Facet> facetList) {
        if (facetList == null) {
            return new Facet[0];
        }
        return facetList.toArray(new Facet[0]);
    }

    public static Hashtable<Class<? extends Facet>, Facet> getFacetsByType(FacetHolder facetHolder) {
        Class<? extends Facet>[] facetsFor;
        Hashtable<Class<? extends Facet>, Facet> facetByType = new Hashtable<Class<? extends Facet>, Facet>();
        for (Class<? extends Facet> facetType : facetsFor = facetHolder.getFacetTypes()) {
            Facet facet = facetHolder.getFacet(facetType);
            facetByType.put(facetType, facet);
        }
        return facetByType;
    }

    public static void copyFacets(FacetHolder source, FacetHolder target) {
        List<Facet> facets = source.getFacets((Filter<Facet>)Filters.any());
        for (Facet facet : facets) {
            target.addFacet(facet);
        }
    }
}

