/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.app;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.layoutmetadata.json.LayoutMetadataReaderFromJson;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorDefault;
import org.apache.isis.core.metamodel.services.container.DomainObjectContainerDefault;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorDefault;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IsisMetaModel
implements ApplicationScopedComponent {
    private final List<Object> services = Lists.newArrayList();
    private State state = State.NOT_INITIALIZED;
    private ObjectReflectorDefault reflector;
    private RuntimeContext runtimeContext;
    private IsisConfiguration configuration;
    private ProgrammingModel programmingModel;
    private Set<FacetDecorator> facetDecorators;
    private MetaModelValidatorComposite metaModelValidator;
    private ValidationFailures validationFailures;

    public IsisMetaModel(RuntimeContext runtimeContext, ProgrammingModel programmingModel, List<Object> services) {
        this(runtimeContext, programmingModel, services.toArray());
    }

    public IsisMetaModel(RuntimeContext runtimeContext, ProgrammingModel programmingModel, Object ... services) {
        this.runtimeContext = runtimeContext;
        this.services.add(new DomainObjectContainerDefault());
        this.services.addAll(Arrays.asList(services));
        this.configuration = new IsisConfigurationDefault();
        this.facetDecorators = new TreeSet<FacetDecorator>();
        this.setProgrammingModelFacets(programmingModel);
        this.metaModelValidator = new MetaModelValidatorComposite();
        programmingModel.refineMetaModelValidator(this.metaModelValidator, this.configuration);
    }

    public List<Object> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    @Override
    public void init() {
        this.ensureNotInitialized();
        ArrayList layoutMetadataReaders = Lists.newArrayList((Object[])new LayoutMetadataReader[]{new LayoutMetadataReaderFromJson()});
        this.reflector = new ObjectReflectorDefault(this.configuration, this.programmingModel, this.facetDecorators, this.metaModelValidator, layoutMetadataReaders);
        ServicesInjectorDefault servicesInjector = new ServicesInjectorDefault(this.services);
        this.reflector.setServiceInjector(servicesInjector);
        this.runtimeContext.injectInto(this.reflector);
        this.reflector.injectInto(this.runtimeContext);
        this.reflector.initialize();
        this.validationFailures = this.reflector.validate();
        this.runtimeContext.init();
        for (Object service : this.services) {
            ObjectSpecification serviceSpec = this.reflector.loadSpecification(service.getClass());
            serviceSpec.markAsService();
        }
        this.state = State.INITIALIZED;
    }

    public ValidationFailures getValidationFailures() {
        return this.validationFailures;
    }

    @Override
    public void shutdown() {
        this.ensureInitialized();
        this.state = State.SHUTDOWN;
    }

    public SpecificationLoaderSpi getSpecificationLoader() {
        return this.reflector;
    }

    public ServicesInjector getDependencyInjector() {
        this.ensureInitialized();
        return this.runtimeContext.getServicesInjector();
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IsisConfiguration configuration) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(configuration, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
    }

    public ProgrammingModel getProgrammingModelFacets() {
        return this.programmingModel;
    }

    public void setProgrammingModelFacets(ProgrammingModel programmingModel) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(programmingModel, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.programmingModel = programmingModel;
    }

    public Set<FacetDecorator> getFacetDecorators() {
        return Collections.unmodifiableSet(this.facetDecorators);
    }

    public void setFacetDecorators(Set<FacetDecorator> facetDecorators) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(facetDecorators, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.facetDecorators = facetDecorators;
    }

    public MetaModelValidatorComposite getMetaModelValidator() {
        return this.metaModelValidator;
    }

    public void setMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        this.metaModelValidator = metaModelValidator;
    }

    private State ensureNotInitialized() {
        return Ensure.ensureThatState(this.state, CoreMatchers.is((Object)((Object)State.NOT_INITIALIZED)));
    }

    private State ensureInitialized() {
        return Ensure.ensureThatState(this.state, CoreMatchers.is((Object)((Object)State.INITIALIZED)));
    }

    private static enum State {
        NOT_INITIALIZED,
        INITIALIZED,
        SHUTDOWN;

    }
}

