/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.version;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.commons.lang.DateExtensions;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;

public class Version
implements Serializable,
Encodable {
    private static final long serialVersionUID = 1L;
    private final Long sequence;
    private final String user;
    private final Long utcTimestamp;

    public static Version create(Long sequence) {
        return Version.create(sequence, null, (Long)null);
    }

    public static Version create(String sequence, String user, String utcTimestamp) {
        if (sequence == null) {
            return null;
        }
        return Version.create((Long)Long.parseLong(sequence), user, utcTimestamp != null ? Long.valueOf(Long.parseLong(utcTimestamp)) : null);
    }

    public static Version create(Long sequence, String user, Date time) {
        return Version.create(sequence, user, time != null ? Long.valueOf(time.getTime()) : null);
    }

    public static Version create(Long sequence, String user, Long utcTimestamp) {
        if (sequence == null) {
            return null;
        }
        return new Version(sequence, user, utcTimestamp);
    }

    private Version(Long sequence, String user, Long utcTimestamp) {
        this.sequence = sequence;
        this.user = user;
        this.utcTimestamp = utcTimestamp;
    }

    public Version(DataInputExtended input) throws IOException {
        this(input.readLong(), input.readUTF(), input.readLong());
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        output.writeLong(this.sequence);
        output.writeUTF(this.user);
        output.writeLong(this.utcTimestamp);
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getUser() {
        return this.user;
    }

    public Long getUtcTimestamp() {
        return this.utcTimestamp;
    }

    public Date getTime() {
        return this.utcTimestamp != null ? new Date(this.utcTimestamp) : null;
    }

    public String enString(OidMarshaller oidMarshaller) {
        return oidMarshaller.marshal(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return !(this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence));
    }

    public boolean different(Version version) {
        return !this.equals(version);
    }

    public String toString() {
        return "#" + this.sequence + " " + this.getUser() + " " + DateExtensions.asTimestamp(this.getTime());
    }

    public String sequence() {
        return Long.toString(this.sequence, 16);
    }
}

