/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.oid.CollectionOid;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;

public class OidMarshaller {
    private static final String TRANSIENT_INDICATOR = "!";
    public static final String VIEWMODEL_INDICATOR = "*";
    private static final String SEPARATOR = ":";
    private static final String SEPARATOR_NESTING = "~";
    private static final String SEPARATOR_COLLECTION = "$";
    private static final String SEPARATOR_VERSION = "^";
    private static final String WORD = "[^:~$\\^#]+";
    private static final String DIGITS = "\\d+";
    private static final String WORD_GROUP = "([^:~$\\^#]+)";
    private static final String DIGITS_GROUP = "(\\d+)";
    private static Pattern OIDSTR_PATTERN = Pattern.compile("^((([!*])?([^:~$\\^#]+):([^:~$\\^#]+))((~[^:~$\\^#]+:[^:~$\\^#]+)*))([$][^:~$\\^#]+)?([\\^](\\d+):([^:~$\\^#]+)?:(\\d+)?)?$");

    public String joinAsOid(String domainType, String instanceId) {
        return domainType + SEPARATOR + instanceId;
    }

    public String splitInstanceId(String oidStr) {
        int indexOfSeperator = oidStr.indexOf(SEPARATOR);
        return indexOfSeperator > 0 ? oidStr.substring(indexOfSeperator + 1) : null;
    }

    public <T extends Oid> T unmarshal(String oidStr, Class<T> requestedType) {
        String collectionPart;
        Matcher matcher = OIDSTR_PATTERN.matcher(oidStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse OID '" + oidStr + "'; should match pattern: " + OIDSTR_PATTERN.pattern());
        }
        String isTransientOrViewModelStr = this.getGroup(matcher, 3);
        Oid.State state = TRANSIENT_INDICATOR.equals(isTransientOrViewModelStr) ? Oid.State.TRANSIENT : (VIEWMODEL_INDICATOR.equals(isTransientOrViewModelStr) ? Oid.State.VIEWMODEL : Oid.State.PERSISTENT);
        String rootOidStr = this.getGroup(matcher, 2);
        String rootObjectType = this.getGroup(matcher, 4);
        String rootIdentifier = this.getGroup(matcher, 5);
        String aggregateOidPart = this.getGroup(matcher, 6);
        ArrayList aggregateOidParts = Lists.newArrayList();
        Splitter nestingSplitter = Splitter.on((String)SEPARATOR_NESTING);
        Splitter partsSplitter = Splitter.on((String)SEPARATOR);
        if (aggregateOidPart != null) {
            Iterable tildaSplitIter = nestingSplitter.split((CharSequence)aggregateOidPart);
            for (String str : tildaSplitIter) {
                if (Strings.isNullOrEmpty((String)str)) continue;
                Iterator colonSplitIter = partsSplitter.split((CharSequence)str).iterator();
                String objectType = (String)colonSplitIter.next();
                String localId = (String)colonSplitIter.next();
                aggregateOidParts.add(new AggregateOidPart(objectType, localId));
            }
        }
        String collectionName = (collectionPart = this.getGroup(matcher, 8)) != null ? collectionPart.substring(1) : null;
        String versionSequence = this.getGroup(matcher, 10);
        String versionUser = this.getGroup(matcher, 11);
        String versionUtcTimestamp = this.getGroup(matcher, 12);
        Version version = Version.create(versionSequence, versionUser, versionUtcTimestamp);
        if (collectionName == null) {
            if (aggregateOidParts.isEmpty()) {
                this.ensureCorrectType(oidStr, requestedType, RootOidDefault.class);
                return (T)new RootOidDefault(ObjectSpecId.of(rootObjectType), rootIdentifier, state, version);
            }
            this.ensureCorrectType(oidStr, requestedType, AggregatedOid.class);
            AggregateOidPart lastPart = (AggregateOidPart)aggregateOidParts.remove(aggregateOidParts.size() - 1);
            TypedOid parentOid = this.parentOidFor(rootOidStr, aggregateOidParts, version);
            return (T)new AggregatedOid(ObjectSpecId.of(lastPart.objectType), parentOid, lastPart.localId);
        }
        String oidStrWithoutCollectionName = this.getGroup(matcher, 1);
        String parentOidStr = oidStrWithoutCollectionName + this.marshal(version);
        TypedOid parentOid = this.unmarshal(parentOidStr, TypedOid.class);
        this.ensureCorrectType(oidStr, requestedType, CollectionOid.class);
        return (T)new CollectionOid(parentOid, collectionName);
    }

    private TypedOid parentOidFor(String rootOidStr, List<AggregateOidPart> aggregateOidParts, Version version) {
        StringBuilder buf = new StringBuilder(rootOidStr);
        for (AggregateOidPart part : aggregateOidParts) {
            buf.append(part.toString());
        }
        buf.append(this.marshal(version));
        return this.unmarshal(buf.toString(), TypedOid.class);
    }

    private <T> void ensureCorrectType(String oidStr, Class<T> requestedType, Class<? extends Oid> actualType) {
        if (!requestedType.isAssignableFrom(actualType)) {
            throw new IllegalArgumentException("OID '" + oidStr + "' does not represent a " + actualType.getSimpleName());
        }
    }

    private String getGroup(Matcher matcher, int group) {
        int groupCount = matcher.groupCount();
        if (group > groupCount) {
            return null;
        }
        String val = matcher.group(group);
        return Strings.emptyToNull((String)val);
    }

    public final String marshal(RootOid rootOid) {
        return this.marshalNoVersion(rootOid) + this.marshal(rootOid.getVersion());
    }

    public final String marshalNoVersion(RootOid rootOid) {
        String transientIndicator = rootOid.isTransient() ? TRANSIENT_INDICATOR : "";
        String viewModelIndicator = rootOid.isViewModel() ? VIEWMODEL_INDICATOR : "";
        return transientIndicator + viewModelIndicator + rootOid.getObjectSpecId() + SEPARATOR + rootOid.getIdentifier();
    }

    public final String marshal(CollectionOid collectionOid) {
        return this.marshalNoVersion(collectionOid) + this.marshal(collectionOid.getVersion());
    }

    public String marshalNoVersion(CollectionOid collectionOid) {
        return collectionOid.getParentOid().enStringNoVersion(this) + SEPARATOR_COLLECTION + collectionOid.getName();
    }

    public final String marshal(AggregatedOid aggregatedOid) {
        return this.marshalNoVersion(aggregatedOid) + this.marshal(aggregatedOid.getVersion());
    }

    public final String marshalNoVersion(AggregatedOid aggregatedOid) {
        return aggregatedOid.getParentOid().enStringNoVersion(this) + SEPARATOR_NESTING + aggregatedOid.getObjectSpecId() + SEPARATOR + aggregatedOid.getLocalId();
    }

    public final String marshal(Version version) {
        if (version == null) {
            return "";
        }
        String versionUser = version.getUser();
        return SEPARATOR_VERSION + version.getSequence() + SEPARATOR + Strings.nullToEmpty((String)versionUser) + SEPARATOR + OidMarshaller.nullToEmpty(version.getUtcTimestamp());
    }

    private static String nullToEmpty(Object obj) {
        return obj == null ? "" : "" + obj;
    }

    private static class AggregateOidPart {
        String objectType;
        String localId;

        AggregateOidPart(String objectType, String localId) {
            this.objectType = objectType;
            this.localId = localId;
        }

        public String toString() {
            return OidMarshaller.SEPARATOR_NESTING + this.objectType + OidMarshaller.SEPARATOR + this.localId;
        }
    }
}

