/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;

public final class AggregatedOid
extends ParentedOid
implements TypedOid,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ObjectSpecId objectSpecId;
    private final String localId;
    private int cachedHashCode;

    public AggregatedOid(ObjectSpecId objectSpecId, TypedOid parentOid, String localId) {
        super(parentOid);
        Assert.assertNotNull("objectSpecId required", objectSpecId);
        Assert.assertNotNull("LocalId required", localId);
        this.objectSpecId = objectSpecId;
        this.localId = localId;
        this.cacheState();
    }

    public static AggregatedOid deString(String oidStr, OidMarshaller oidMarshaller) {
        return oidMarshaller.unmarshal(oidStr, AggregatedOid.class);
    }

    @Override
    public String enString(OidMarshaller oidMarshaller) {
        return oidMarshaller.marshal(this);
    }

    @Override
    public String enStringNoVersion(OidMarshaller oidMarshaller) {
        return oidMarshaller.marshalNoVersion(this);
    }

    public AggregatedOid(DataInputExtended input) throws IOException {
        this(AggregatedOid.deString(input.readUTF(), AggregatedOid.getEncodingMarshaller()));
    }

    private AggregatedOid(AggregatedOid oid) throws IOException {
        super(oid.getParentOid());
        this.objectSpecId = oid.objectSpecId;
        this.localId = oid.localId;
        this.cacheState();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.enString(AggregatedOid.getEncodingMarshaller()));
    }

    private static OidMarshaller getEncodingMarshaller() {
        return new OidMarshaller();
    }

    @Override
    public ObjectSpecId getObjectSpecId() {
        return this.objectSpecId;
    }

    public String getLocalId() {
        return this.localId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((AggregatedOid)other);
    }

    public boolean equals(AggregatedOid other) {
        return Objects.equal((Object)other.getParentOid(), (Object)this.getParentOid()) && Objects.equal((Object)other.objectSpecId, (Object)this.objectSpecId) && Objects.equal((Object)other.localId, (Object)this.localId);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private void cacheState() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.getParentOid().hashCode();
        hashCode = 37 * hashCode + this.objectSpecId.hashCode();
        this.cachedHashCode = hashCode = 37 * hashCode + this.localId.hashCode();
    }

    public AggregatedOid asPersistent(TypedOid newParentOid) {
        return new AggregatedOid(this.objectSpecId, newParentOid, this.localId);
    }
}

