/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ResolveState {
    private static final Map<String, ResolveState> statesByName = Maps.newHashMap();
    public static final ResolveState NEW = new ResolveState("New", "N~~", null, TransitionFrom.CANNOT_TRANSITION_FROM, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT);
    public static final ResolveState TRANSIENT = new ResolveState("Transient", "T~~", null, TransitionFrom.CANNOT_TRANSITION_FROM, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT);
    public static final ResolveState GHOST = new ResolveState("Ghost", "PG~", null, TransitionFrom.CAN_TRANSITION_FROM, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsPersistent.REPRESENTS_PERSISTENT);
    public static final ResolveState RESOLVED = new ResolveState("Resolved", "PR~", null, TransitionFrom.CAN_TRANSITION_FROM, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsPersistent.REPRESENTS_PERSISTENT);
    public static final ResolveState RESOLVING = new ResolveState("Resolving", "Pr~", RESOLVED, TransitionFrom.CANNOT_TRANSITION_FROM, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsPersistent.REPRESENTS_PERSISTENT);
    public static final ResolveState UPDATING = new ResolveState("Updating", "PU~", RESOLVED, TransitionFrom.CANNOT_TRANSITION_FROM, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsPersistent.REPRESENTS_PERSISTENT);
    public static final ResolveState DESTROYED = new ResolveState("Destroyed", "D~~", null, TransitionFrom.CANNOT_TRANSITION_FROM, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT);
    public static final ResolveState VALUE = new ResolveState("Value", "V~~", null, TransitionFrom.CANNOT_TRANSITION_FROM, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT);
    public static Map<ResolveState, ResolveState[]> changeToStatesByState = new HashMap<ResolveState, ResolveState[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(GHOST, new ResolveState[]{DESTROYED, RESOLVING, UPDATING});
            this.put(NEW, new ResolveState[]{TRANSIENT, GHOST, VALUE});
            this.put(TRANSIENT, new ResolveState[]{RESOLVED});
            this.put(RESOLVING, new ResolveState[]{RESOLVED});
            this.put(RESOLVED, new ResolveState[]{GHOST, UPDATING, DESTROYED});
            this.put(UPDATING, new ResolveState[]{RESOLVED});
            this.put(DESTROYED, new ResolveState[0]);
            this.put(VALUE, new ResolveState[0]);
        }
    };
    private final String code;
    private final ResolveState endState;
    private final String name;
    private final TransitionFrom transitionFrom;
    private final RespondsToChanges respondsToChanges;
    private final RepresentsPersistent representsPersistent;
    private HashSet<ResolveState> changeToStates;
    private transient String cachedToString;

    private ResolveState(String name, String code, ResolveState endState, TransitionFrom transitionFrom, RespondsToChanges respondsToChanges, RepresentsPersistent representsPersistent) {
        this.name = name;
        this.code = code;
        this.endState = endState;
        this.transitionFrom = transitionFrom;
        this.respondsToChanges = respondsToChanges;
        this.representsPersistent = representsPersistent;
        statesByName.put(name, this);
    }

    public String code() {
        return this.code;
    }

    public ResolveState getEndState() {
        return this.endState;
    }

    public boolean representsPersistent() {
        return this.representsPersistent == RepresentsPersistent.REPRESENTS_PERSISTENT;
    }

    public boolean canTransitionToResolving() {
        if (this.transitionFrom != TransitionFrom.CAN_TRANSITION_FROM) {
            return false;
        }
        return this.isValidToChangeTo(RESOLVING);
    }

    public boolean respondToChangesInPersistentObjects() {
        return this.respondsToChanges == RespondsToChanges.RESPONDS_TO_CHANGES;
    }

    public boolean isNew() {
        return this == NEW;
    }

    public boolean isValue() {
        return this == VALUE;
    }

    public boolean isTransient() {
        return this == TRANSIENT;
    }

    public boolean isGhost() {
        return this == GHOST;
    }

    public boolean isUpdating() {
        return this == UPDATING;
    }

    public boolean isResolved() {
        return this == RESOLVED;
    }

    public boolean isResolving() {
        return this == RESOLVING;
    }

    public boolean isDestroyed() {
        return this == DESTROYED;
    }

    public boolean isValidToChangeTo(ResolveState nextState) {
        this.cacheChangeToStatesIfNecessary();
        return this.changeToStates.contains(nextState);
    }

    private void cacheChangeToStatesIfNecessary() {
        if (this.changeToStates == null) {
            List<Object> nextStates = Arrays.asList((Object[])changeToStatesByState.get(this));
            this.changeToStates = new HashSet<Object>(nextStates);
        }
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer str = new StringBuffer();
            str.append("ResolveState [name=");
            str.append(this.name);
            str.append(",code=");
            str.append(this.code);
            if (this.endState != null) {
                str.append(",endstate=");
                str.append(this.endState.name());
            }
            str.append("]");
            this.cachedToString = str.toString();
        }
        return this.cachedToString;
    }

    static enum RepresentsPersistent {
        REPRESENTS_PERSISTENT,
        DOES_NOT_REPRESENT_PERSISTENT;

    }

    static enum RespondsToChanges {
        RESPONDS_TO_CHANGES,
        DOES_NOT_RESPOND_TO_CHANGES;

    }

    static enum TransitionFrom {
        CAN_TRANSITION_FROM,
        CANNOT_TRANSITION_FROM;

    }
}

