/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceAbstract;

public class ResourceStreamSourceFileSystem
extends ResourceStreamSourceAbstract {
    private final String directory;

    public static ResourceStreamSource create(String directory) {
        if (directory == null) {
            return null;
        }
        File file = new File(directory);
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        try {
            return new ResourceStreamSourceFileSystem(file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceStreamSourceFileSystem(String directory) {
        this.directory = directory;
    }

    @Override
    protected InputStream doReadResource(String resourcePath) throws FileNotFoundException {
        File file = new File(this.directory, resourcePath);
        return new FileInputStream(file);
    }

    @Override
    public OutputStream writeResource(String resourcePath) {
        File file = new File(this.directory, resourcePath);
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "file system (directory '" + this.directory + "')";
    }
}

