/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.resource;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamSourceChainOfResponsibility
extends ResourceStreamSourceAbstract {
    private static Logger LOG = LoggerFactory.getLogger(ResourceStreamSourceChainOfResponsibility.class);
    private final List<ResourceStreamSource> resourceStreamSources = new ArrayList<ResourceStreamSource>();

    public ResourceStreamSourceChainOfResponsibility(ResourceStreamSource ... resourceStreamSources) {
        for (ResourceStreamSource rss : resourceStreamSources) {
            this.addResourceStreamSource(rss);
        }
    }

    public void addResourceStreamSource(ResourceStreamSource rss) {
        this.resourceStreamSources.add(rss);
    }

    @Override
    protected InputStream doReadResource(String resourcePath) {
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            InputStream resourceStream = rss.readResource(resourcePath);
            if (resourceStream == null) continue;
            return resourceStream;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("could not load resource path '" + resourcePath + "' from " + this.getName());
        }
        return null;
    }

    @Override
    public OutputStream writeResource(String resourcePath) {
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            OutputStream os = rss.writeResource(resourcePath);
            if (os == null) continue;
            return os;
        }
        return null;
    }

    @Override
    public String getName() {
        return "chain [" + this.resourceStreamNames() + "]";
    }

    private String resourceStreamNames() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(rss.getName());
        }
        return buf.toString();
    }
}

