/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.factory;

import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.factory.InstanceCreationClassException;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.commons.factory.UnavailableClassException;
import org.apache.isis.core.commons.lang.ObjectExtensions;

public final class InstanceUtil {
    private InstanceUtil() {
    }

    public static Object createInstance(String className) {
        return InstanceUtil.createInstance(className, (Class)null, null);
    }

    public static Object createInstance(Class<?> cls) {
        return InstanceUtil.createInstance(cls, (Class)null, null);
    }

    public static <T> T createInstance(String className, Class<T> requiredClass) {
        return InstanceUtil.createInstance(className, (Class)null, requiredClass);
    }

    public static <T> T createInstance(Class<?> cls, Class<T> requiredClass) {
        return InstanceUtil.createInstance(cls, (Class)null, requiredClass);
    }

    public static <T> T createInstance(String className, String defaultTypeName, Class<T> requiredType) {
        Class defaultType = null;
        if (defaultTypeName != null) {
            try {
                defaultType = (Class)ObjectExtensions.asT(Thread.currentThread().getContextClassLoader().loadClass(defaultTypeName));
                if (defaultType == null) {
                    throw new InstanceCreationClassException(String.format("Failed to load default type '%s'", defaultTypeName));
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnavailableClassException(String.format("The default type '%s' cannot be found", defaultTypeName));
            }
            catch (NoClassDefFoundError e) {
                throw new InstanceCreationClassException(String.format("Default type '%s' found, but is missing a dependent class: %s", defaultTypeName, e.getMessage()), e);
            }
        }
        return InstanceUtil.createInstance(className, defaultType, requiredType);
    }

    public static <T> T createInstance(Class<?> cls, String defaultTypeName, Class<T> requiredType) {
        Class defaultType = null;
        if (defaultTypeName != null) {
            defaultType = InstanceUtil.loadClass(defaultTypeName, requiredType);
            try {
                defaultType = (Class)ObjectExtensions.asT(Thread.currentThread().getContextClassLoader().loadClass(defaultTypeName));
                if (defaultType == null) {
                    throw new InstanceCreationClassException(String.format("Failed to load default type '%s'", defaultTypeName));
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnavailableClassException(String.format("The default type '%s' cannot be found", defaultTypeName));
            }
            catch (NoClassDefFoundError e) {
                throw new InstanceCreationClassException(String.format("Default type '%s' found, but is missing a dependent class: %s", defaultTypeName, e.getMessage()), e);
            }
        }
        return InstanceUtil.createInstance(cls, defaultType, requiredType);
    }

    public static <T> T createInstance(String className, Class<? extends T> defaultType, Class<T> requiredType) {
        Assert.assertNotNull("Class to instantiate must be specified", className);
        Class<?> cls = null;
        try {
            cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (cls == null) {
                throw new InstanceCreationClassException(String.format("Failed to load class '%s'", className));
            }
            return InstanceUtil.createInstance(cls, defaultType, requiredType);
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(46) == -1) {
                throw new UnavailableClassException(String.format("The component '%s' cannot be found", className));
            }
            throw new UnavailableClassException(String.format("The class '%s' cannot be found", className));
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException(String.format("Class '%s' found , but is missing a dependent class: %s", className, e.getMessage()), e);
        }
    }

    public static <T> T createInstance(Class<?> cls, Class<? extends T> defaultType, Class<T> requiredType) {
        Assert.assertNotNull("Class to instantiate must be specified", cls);
        try {
            if (requiredType == null || requiredType.isAssignableFrom(cls)) {
                Class tClass = (Class)ObjectExtensions.asT(cls);
                return tClass.newInstance();
            }
            throw new InstanceCreationClassException(String.format("Class '%s' is not of type '%s'", cls.getName(), requiredType));
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException(String.format("Class '%s'found , but is missing a dependent class: %s", cls, e.getMessage()), e);
        }
        catch (InstantiationException e) {
            throw new InstanceCreationException(String.format("Could not instantiate an object of class '%s'; %s", cls.getName(), e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw new InstanceCreationException(String.format("Could not access the class '%s'; %s", cls.getName(), e.getMessage()));
        }
    }

    public static Class<?> loadClass(String className) {
        Assert.assertNotNull("Class to instantiate must be specified", className);
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new UnavailableClassException(String.format("The type '%s' cannot be found", className));
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException(String.format("Type '%s' found, but is missing a dependent class: %s", className, e.getMessage()), e);
        }
    }

    public static <R, T extends R> Class<T> loadClass(String className, Class<R> requiredType) {
        Assert.assertNotNull("Class to instantiate must be specified", className);
        try {
            Class<?> loadedClass = InstanceUtil.loadClass(className);
            if (requiredType != null && !requiredType.isAssignableFrom(loadedClass)) {
                throw new InstanceCreationClassException("Class '" + className + "' is not of type '" + requiredType + "'");
            }
            return (Class)ObjectExtensions.asT(loadedClass);
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException(String.format("Default type '%s' found, but is missing a dependent class: %s", className, e.getMessage()), e);
        }
    }
}

