/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.encoding;

import java.io.IOException;
import java.util.Arrays;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataInputExtendedDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugDataInputExtended
extends DataInputExtendedDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(DebugDataInputExtended.class);

    public DebugDataInputExtended(DataInputExtended input) {
        super(input);
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean b = super.readBoolean();
        if (LOG.isDebugEnabled()) {
            LOG.debug("boolean: " + b);
        }
        return b;
    }

    @Override
    public byte readByte() throws IOException {
        byte b = super.readByte();
        if (LOG.isDebugEnabled()) {
            LOG.debug("byte: " + b);
        }
        return b;
    }

    @Override
    public byte[] readBytes() throws IOException {
        byte[] bs = super.readBytes();
        if (LOG.isDebugEnabled()) {
            LOG.debug("bytes: " + new String(bs));
        }
        return bs;
    }

    @Override
    public int readInt() throws IOException {
        int i = super.readInt();
        if (LOG.isDebugEnabled()) {
            LOG.debug("int: " + i);
        }
        return i;
    }

    @Override
    public long readLong() throws IOException {
        long l = super.readLong();
        if (LOG.isDebugEnabled()) {
            LOG.debug("long: " + l);
        }
        return l;
    }

    @Override
    public String readUTF() throws IOException {
        String string = super.readUTF();
        if (LOG.isDebugEnabled()) {
            LOG.debug("string: " + string);
        }
        return string;
    }

    @Override
    public String[] readUTFs() throws IOException {
        Object[] strings = super.readUTFs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("list: " + Arrays.toString(strings));
        }
        return strings;
    }

    @Override
    public <T> T readEncodable(Class<T> encodableType) throws IOException {
        T object = super.readEncodable(encodableType);
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>> object");
        }
        return object;
    }

    @Override
    public <T> T[] readEncodables(Class<T> encodableType) throws IOException {
        T[] objects = super.readEncodables(encodableType);
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>> objects x" + objects.length);
        }
        return objects;
    }
}

