/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.debug;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;

public class DebugList {
    private final List<String[]> names = Lists.newArrayList();
    private final List<DebuggableWithTitle> debuggableList = Lists.newArrayList();

    public DebugList(final String name) {
        this.debuggableList.add(new DebuggableWithTitle(){

            @Override
            public void debugData(DebugBuilder debug) {
                for (String[] name2 : DebugList.this.names) {
                    debug.appendln(name2[0], name2[1]);
                }
            }

            @Override
            public String debugTitle() {
                return name;
            }
        });
    }

    public void add(String name, Object object) {
        boolean b = object instanceof DebuggableWithTitle;
        if (b) {
            this.debuggableList.add((DebuggableWithTitle)object);
        }
        if (object != null) {
            String[] n = new String[]{name + (b ? "*" : ""), object.toString()};
            this.names.add(n);
        }
    }

    public DebuggableWithTitle[] debug() {
        return this.debuggableList.toArray(new DebuggableWithTitle[this.debuggableList.size()]);
    }
}

