/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;

public abstract class DebugHtmlStringAbstract
implements DebugBuilder {
    private final boolean createPage;
    private int tableLevel;
    private boolean isOdd;
    private boolean titleShown;
    private boolean endLine;

    public DebugHtmlStringAbstract(boolean createPage) {
        this.createPage = createPage;
    }

    @Override
    public void concat(DebugBuilder debug) {
        this.appendHtml(debug.toString());
    }

    @Override
    public void append(int number, int width) {
        this.appendHtml(number + "");
    }

    @Override
    public void append(Object object) {
        if (object instanceof DebuggableWithTitle) {
            DebuggableWithTitle d = (DebuggableWithTitle)object;
            this.appendTitle(d.debugTitle());
            d.debugData(this);
        } else {
            this.appendHtml(object.toString());
        }
    }

    @Override
    public void append(Object object, int width) {
        this.appendHtml(object.toString());
    }

    @Override
    public void appendln() {
        if (this.tableLevel > 0) {
            this.endLine = true;
        } else {
            this.appendHtml("<p></p>");
        }
    }

    @Override
    public void blankLine() {
        if (this.tableLevel > 0) {
            this.appendHtml(this.row() + "<td class=\"error\" colspan=\"2\" >blank line</td></tr>");
        } else {
            this.appendHtml("<p>blank line</p>");
        }
    }

    @Override
    public void appendln(String label, boolean value) {
        this.appendln(label, String.valueOf(value));
    }

    @Override
    public void appendln(String label, double value) {
        this.appendln(label, String.valueOf(value));
    }

    @Override
    public void appendln(String label, long value) {
        this.appendln(label, String.valueOf(value));
    }

    @Override
    public void appendAsHexln(String label, long value) {
        this.appendln(label, Long.toHexString(value));
    }

    @Override
    public void appendPreformatted(String label, String object) {
        String value = object == null ? "null" : object.toString();
        this.appendln(label, "<pre>" + value + "</pre>");
    }

    @Override
    public void appendln(String label, Object object) {
        String value = object == null ? "null" : object.toString();
        this.appendln(label, value);
    }

    @Override
    public void appendln(String label, Object[] object) {
        if (object.length == 0) {
            this.appendln(label, "empty array");
        } else {
            this.appendln(label, object[0]);
            for (int i = 1; i < object.length; ++i) {
                this.appendHtml(this.row() + "<td></td><td>" + object[i] + "</td></tr>");
            }
        }
    }

    @Override
    public void startSection(String title) {
        this.startTableIfNeeded(true);
        this.appendTitle(title);
    }

    @Override
    public void endSection() {
        this.endTableIfStarted();
    }

    @Override
    public void indent() {
        if (this.tableLevel > 0) {
            this.appendHtml(this.row() + "<td>indented</td><td>");
            this.startTableIfNeeded(true);
        }
    }

    @Override
    public void unindent() {
        if (this.tableLevel > 0) {
            this.endTableIfStarted();
            this.appendHtml("</td>");
        }
    }

    protected void header() {
        if (this.createPage) {
            this.appendHtml("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
            this.appendHtml("<html>");
            this.appendHtml("<head>");
            this.appendHtml("<title>Debug Details</title>");
            this.appendHtml("<style type=\"text/css\">");
            this.appendHtml("body { margin: 15px; }\n.links { background: #ddd; font-size: 80%; padding-bottom:5px; }\n.links > p { display: inline-block; }\ntd {vertical-align: top; margin-left: 15px;}\ntd.error {color: red; font-style: italic; }\ntd.code {white-space: pre; font-family: monospace;}\nth.title {text-align: left; padding: 0.3em 1em; font-style: italic; background: #AED1FF; }\ntd.label {width: 16em; text-align: right; padding-right: 1.5em; padding-top: 0.2em; font-size: 80%; font-weight: bold; }\nspan.facet-type { font-weight: bold; padding-right: 10px; }\n");
            this.appendHtml("</style>");
            this.appendHtml("</head>");
            this.appendHtml("<body>");
        }
    }

    protected abstract void appendHtml(String var1);

    protected void footer() {
        this.endTableIfStarted();
        if (this.createPage) {
            this.appendHtml("</body>");
            this.appendHtml("</html>");
        }
    }

    @Override
    public void appendException(Throwable e) {
        this.appendTitle("Exception");
        String message = e.getMessage();
        if (message != null) {
            this.appendHtml(this.row() + "<td class=\"error\" colspan=\"2\" >" + message + "</td></tr>");
        }
        this.causingException(e);
        this.appendHtml(this.row() + "<td class=\"code\" colspan=\"2\" ><pre>");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        this.appendHtml(stringWriter.toString());
        this.appendHtml("</pre></td></tr>");
    }

    private void causingException(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause != null && cause != throwable) {
            this.appendHtml(this.row() + "<td colspan=\"2\" >" + cause.getMessage() + "</td></tr>");
            this.causingException(cause);
        }
    }

    @Override
    public void appendTitle(String title) {
        if (this.tableLevel > 0) {
            String className = this.titleShown ? "subtitle" : "title";
            this.appendHtml(this.row() + "<th class=\"" + className + "\" colspan=\"2\" >" + title + "</th></tr>");
            this.titleShown = true;
        } else {
            this.appendHtml("<h2>" + title + "</h2>");
        }
    }

    private void appendln(String name, String value) {
        this.startTableIfNeeded(false);
        this.appendHtml(this.row() + "<td class=\"label\">" + name + "</td><td>" + value + "</td></tr>");
    }

    private String row() {
        String line = (this.isOdd ? "odd" : "even") + (this.endLine ? " end-line" : "");
        this.isOdd = !this.isOdd;
        this.endLine = false;
        return "<tr class=\"" + line + "\">";
    }

    private void startTableIfNeeded(boolean b) {
        if (this.tableLevel == 0 || b) {
            this.appendHtml("<table class=\"debug\" summary=\"Debug details\" >");
            ++this.tableLevel;
            this.titleShown = false;
        }
    }

    private void endTableIfStarted() {
        if (this.tableLevel > 0) {
            this.appendHtml("</table>");
            --this.tableLevel;
        }
    }

    @Override
    public void appendPreformatted(String text) {
        this.appendln("<pre>" + text + "</pre>");
    }

    @Override
    public void appendln(String text) {
        if (this.tableLevel > 0) {
            this.appendHtml(this.row() + "<td colspan=\"2\">" + text + "</td></tr>");
        } else {
            this.appendHtml("<p>" + text + "</p>");
        }
    }

    @Override
    public void close() {
        this.endTableIfStarted();
        this.doClose();
    }

    protected abstract void doClose();
}

