/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderResourceStreams;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceContextLoaderClassPath;
import org.apache.isis.core.commons.resource.ResourceStreamSourceFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisConfigurationBuilderDefault
extends IsisConfigurationBuilderResourceStreams {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationBuilderDefault.class);

    public IsisConfigurationBuilderDefault() {
        super(IsisConfigurationBuilderDefault.resourceStreamSources(null));
    }

    public IsisConfigurationBuilderDefault(String firstDirectory) {
        super(IsisConfigurationBuilderDefault.resourceStreamSources(firstDirectory));
    }

    private static ResourceStreamSource[] resourceStreamSources(String firstDirectory) {
        ArrayList rssList = Lists.newArrayList();
        if (firstDirectory != null) {
            rssList.add(IsisConfigurationBuilderDefault.fromFileSystem(firstDirectory));
        }
        rssList.addAll(Arrays.asList(IsisConfigurationBuilderDefault.fromFileSystem("config"), IsisConfigurationBuilderDefault.fromFileSystem("src/main/webapp/WEB-INF"), IsisConfigurationBuilderDefault.fromClassPath(), IsisConfigurationBuilderDefault.fromClassPath("WEB-INF")));
        return rssList.toArray(new ResourceStreamSource[0]);
    }

    private static ResourceStreamSource fromFileSystem(String directory) {
        return ResourceStreamSourceFileSystem.create(directory);
    }

    private static ResourceStreamSource fromClassPath() {
        return ResourceStreamSourceContextLoaderClassPath.create();
    }

    private static ResourceStreamSource fromClassPath(String prefix) {
        return ResourceStreamSourceContextLoaderClassPath.create(prefix);
    }
}

