/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.authentication;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;

public class MessageBroker
implements Serializable,
DebuggableWithTitle {
    private static final long serialVersionUID = 1L;
    private final List<String> messages = Lists.newArrayList();
    private final List<String> warnings = Lists.newArrayList();
    private String applicationError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageBroker acquire(AuthenticationSession authenticationSession) {
        MessageBroker messageBroker;
        AuthenticationSession authenticationSession2 = authenticationSession;
        synchronized (authenticationSession2) {
            messageBroker = authenticationSession.getMessageBroker();
            if (messageBroker == null) {
                messageBroker = new MessageBroker();
                authenticationSession.setMessageBroker(messageBroker);
            }
        }
        return messageBroker;
    }

    private MessageBroker() {
    }

    public void reset() {
        this.warnings.clear();
        this.messages.clear();
        this.applicationError = null;
    }

    public List<String> getMessages() {
        return this.copyAndClear(this.messages);
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public List<String> getWarnings() {
        return this.copyAndClear(this.warnings);
    }

    public void addWarning(String message) {
        this.warnings.add(message);
    }

    public String getApplicationError() {
        String error = this.applicationError;
        this.setApplicationError(null);
        return error;
    }

    public void setApplicationError(String applicationError) {
        this.applicationError = applicationError;
    }

    @Override
    public void debugData(DebugBuilder debug) {
        this.debugArray(debug, "Messages", this.messages);
        this.debugArray(debug, "Warnings", this.messages);
    }

    private void debugArray(DebugBuilder debug, String title, List<String> vector) {
        debug.appendln(title);
        debug.indent();
        if (vector.size() == 0) {
            debug.appendln("none");
        } else {
            for (String text : vector) {
                debug.appendln(text);
            }
        }
        debug.unindent();
    }

    @Override
    public String debugTitle() {
        return "Simple Message Broker";
    }

    private List<String> copyAndClear(List<String> messages) {
        List<String> copy = Collections.unmodifiableList(new ArrayList<String>(messages));
        messages.clear();
        return copy;
    }
}

