/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.integtestsupport;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.integtestsupport.IsisComponentProviderDefault;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.fixtures.FixturesInstaller;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerDelegate;
import org.apache.isis.core.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfigurationAndAnnotation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystem;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.ObjectStore;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.apache.isis.core.security.authentication.AuthenticationRequestNameOnly;
import org.apache.isis.core.specsupport.scenarios.DomainServiceProvider;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class IsisSystemForTest
implements TestRule,
DomainServiceProvider {
    private static ThreadLocal<IsisSystemForTest> ISFT = new ThreadLocal();
    private Level level = Level.INFO;
    private final AppManifest appManifestForComponentProvider;
    private final IsisConfiguration configurationForComponentProvider;
    private final List<Object> servicesForComponentProvider;
    private final List<InstallableFixture> fixturesForComponentProvider;
    private final MetaModelValidator metaModelValidatorForComponentProvider;
    private final ProgrammingModel programmingModelForComponentProvider;
    private IsisComponentProvider componentProvider;
    private IsisSystem isisSystem;
    private final AuthenticationRequest authenticationRequestIfAny;
    private AuthenticationSession authenticationSession;
    private List<Listener> listeners;

    public static IsisSystemForTest getElseNull() {
        return ISFT.get();
    }

    public static IsisSystemForTest get() {
        IsisSystemForTest isft = ISFT.get();
        if (isft == null) {
            throw new IllegalStateException("No IsisSystemForTest available on thread; call #set(IsisSystemForTest) first");
        }
        return isft;
    }

    public static void set(IsisSystemForTest isft) {
        ISFT.set(isft);
    }

    public static Builder builder() {
        return new Builder();
    }

    private IsisSystemForTest(AppManifest appManifestIfAny, IsisConfiguration configurationOverride, List<Object> servicesIfAny, List<InstallableFixture> fixturesIfAny, ProgrammingModel programmingModelOverride, MetaModelValidator metaModelValidatorOverride, AuthenticationRequest authenticationRequest, List<Listener> listeners) {
        this.appManifestForComponentProvider = appManifestIfAny;
        this.configurationForComponentProvider = configurationOverride;
        this.servicesForComponentProvider = servicesIfAny;
        this.fixturesForComponentProvider = fixturesIfAny;
        this.programmingModelForComponentProvider = programmingModelOverride;
        this.metaModelValidatorForComponentProvider = metaModelValidatorOverride;
        this.authenticationRequestIfAny = authenticationRequest;
        this.listeners = listeners;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public IsisSystemForTest setUpSystem() throws RuntimeException {
        try {
            this.setUpSystem(FireListeners.FIRE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private void setUpSystem(FireListeners fireListeners) throws Exception {
        boolean firstTime;
        boolean bl = firstTime = this.isisSystem == null;
        if (fireListeners.shouldFire()) {
            this.fireInitAndPreSetupSystem(firstTime);
        }
        if (firstTime) {
            IsisLoggingConfigurer isisLoggingConfigurer = new IsisLoggingConfigurer(this.getLevel());
            isisLoggingConfigurer.configureLogging(".", new String[0]);
            this.componentProvider = new IsisComponentProviderDefault(DeploymentType.UNIT_TESTING, this.appManifestForComponentProvider, this.servicesForComponentProvider, this.fixturesForComponentProvider, this.configurationForComponentProvider, this.programmingModelForComponentProvider, this.metaModelValidatorForComponentProvider);
            this.isisSystem = new IsisSystem(this.componentProvider);
            FixtureClock.initialize();
            this.isisSystem.init();
            IsisContext.closeSession();
        }
        AuthenticationManager authenticationManager = this.isisSystem.getSessionFactory().getAuthenticationManager();
        this.authenticationSession = authenticationManager.authenticate(this.authenticationRequestIfAny);
        this.setContainer(this.getContainer());
        this.openSession();
        this.wireAndInstallFixtures();
        if (fireListeners.shouldFire()) {
            this.firePostSetupSystem(firstTime);
        }
    }

    private void wireAndInstallFixtures() {
        FixturesInstaller fixturesInstaller = this.componentProvider.provideFixturesInstaller();
        fixturesInstaller.installFixtures();
    }

    public DomainObjectContainer getContainer() {
        for (Object service : this.isisSystem.getSessionFactory().getServices()) {
            if (!(service instanceof DomainObjectContainer)) continue;
            return (DomainObjectContainer)service;
        }
        throw new IllegalStateException("Could not locate DomainObjectContainer");
    }

    public void tearDownSystem() throws Exception {
        this.tearDownSystem(FireListeners.FIRE);
    }

    private void tearDownSystem(FireListeners fireListeners) throws Exception {
        if (fireListeners.shouldFire()) {
            this.firePreTeardownSystem();
        }
        IsisContext.closeSession();
        if (fireListeners.shouldFire()) {
            this.firePostTeardownSystem();
        }
    }

    private void shutdown() {
        this.isisSystem.shutdown();
    }

    public void bounceSystem() throws Exception {
        this.firePreBounceSystem();
        this.closeSession();
        this.openSession();
        this.firePostBounceSystem();
    }

    public void openSession() throws Exception {
        this.openSession(this.authenticationSession);
    }

    public void openSession(AuthenticationSession authenticationSession) throws Exception {
        IsisContext.openSession((AuthenticationSession)authenticationSession);
    }

    public void closeSession() throws Exception {
        IsisContext.closeSession();
    }

    private void fireInitAndPreSetupSystem(boolean firstTime) throws Exception {
        if (firstTime) {
            for (Listener listener : this.listeners) {
                listener.init(this.componentProvider.getConfiguration());
            }
        }
        for (Listener listener : this.listeners) {
            listener.preSetupSystem(firstTime);
        }
    }

    private void firePostSetupSystem(boolean firstTime) throws Exception {
        for (Listener listener : this.listeners) {
            listener.postSetupSystem(firstTime);
        }
    }

    private void firePreTeardownSystem() throws Exception {
        for (Listener listener : this.listeners) {
            listener.preTeardownSystem();
        }
    }

    private void firePostTeardownSystem() throws Exception {
        for (Listener listener : this.listeners) {
            listener.postTeardownSystem();
        }
    }

    private void firePreBounceSystem() throws Exception {
        for (Listener listener : this.listeners) {
            listener.preBounceSystem();
        }
    }

    private void firePostBounceSystem() throws Exception {
        for (Listener listener : this.listeners) {
            listener.postBounceSystem();
        }
    }

    public IsisSystem getIsisSystem() {
        return this.isisSystem;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public ObjectSpecification loadSpecification(Class<?> cls) {
        return this.getIsisSystem().getSessionFactory().getSpecificationLoader().loadSpecification(cls);
    }

    public ObjectAdapter persist(Object domainObject) {
        IsisSystemForTest.ensureSessionInProgress();
        this.ensureObjectIsNotPersistent(domainObject);
        this.getContainer().persist(domainObject);
        return this.adapterFor(domainObject);
    }

    public ObjectAdapter destroy(Object domainObject) {
        IsisSystemForTest.ensureSessionInProgress();
        this.ensureObjectIsPersistent(domainObject);
        this.getContainer().remove(domainObject);
        return this.adapterFor(domainObject);
    }

    public ObjectAdapter adapterFor(Object domainObject) {
        IsisSystemForTest.ensureSessionInProgress();
        return this.getAdapterManager().adapterFor(domainObject);
    }

    public ObjectAdapter reload(RootOid oid) {
        IsisSystemForTest.ensureSessionInProgress();
        PersistenceSession persistenceSession = this.getPersistenceSession();
        return persistenceSession.loadObject((TypedOid)oid);
    }

    public ObjectAdapter recreateAdapter(RootOid oid) {
        IsisSystemForTest.ensureSessionInProgress();
        return this.getAdapterManager().adapterFor((TypedOid)oid);
    }

    public ObjectAdapter remapAsPersistent(Object pojo, RootOid persistentOid) {
        IsisSystemForTest.ensureSessionInProgress();
        this.ensureObjectIsNotPersistent(pojo);
        ObjectAdapter adapter = this.adapterFor(pojo);
        this.getPersistenceSession().getAdapterManager().remapAsPersistent(adapter, persistentOid);
        return adapter;
    }

    public <T extends ObjectStore> T getObjectStore(Class<T> cls) {
        PersistenceSession persistenceSession = this.getPersistenceSession();
        return (T)persistenceSession.getObjectStore();
    }

    private static void ensureSessionInProgress() {
        if (!IsisContext.inSession()) {
            throw new IllegalStateException("Session must be in progress");
        }
    }

    private void ensureObjectIsNotPersistent(Object domainObject) {
        if (this.getContainer().isPersistent(domainObject)) {
            throw new IllegalArgumentException("domain object is already persistent");
        }
    }

    private void ensureObjectIsPersistent(Object domainObject) {
        if (!this.getContainer().isPersistent(domainObject)) {
            throw new IllegalArgumentException("domain object is not persistent");
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                IsisSystemForTest.this.setUpSystem();
                try {
                    base.evaluate();
                    IsisSystemForTest.this.tearDownSystem();
                }
                catch (Throwable ex) {
                    try {
                        IsisSystemForTest.this.tearDownSystem();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
        };
    }

    public void beginTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getTransaction();
        if (transaction == null) {
            this.startTransactionForUser(transactionManager);
            return;
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: 
            case ABORTED: {
                this.startTransactionForUser(transactionManager);
                break;
            }
            case IN_PROGRESS: {
                break;
            }
            case MUST_ABORT: {
                Assert.fail((String)("Transaction is in state of '" + state + "'"));
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    private void startTransactionForUser(IsisTransactionManager transactionManager) {
        transactionManager.startTransaction();
        CommandContext commandContext = this.getService(CommandContext.class);
        if (commandContext != null) {
            Command command = commandContext.getCommand();
            command.setExecutor(Command.Executor.USER);
        }
    }

    public void endTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getTransaction();
        if (transaction == null) {
            Assert.fail((String)"No transaction exists");
            return;
        }
        transactionManager.endTransaction();
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: {
                break;
            }
            case ABORTED: {
                break;
            }
            case IN_PROGRESS: {
                Assert.fail((String)("Transaction is still in state of '" + state + "'"));
                break;
            }
            case MUST_ABORT: {
                Assert.fail((String)("Transaction is still in state of '" + state + "'"));
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    @Deprecated
    public void commitTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getTransaction();
        if (transaction == null) {
            Assert.fail((String)"No transaction exists");
            return;
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: 
            case ABORTED: 
            case MUST_ABORT: {
                Assert.fail((String)("Transaction is in state of '" + state + "'"));
                break;
            }
            case IN_PROGRESS: {
                transactionManager.endTransaction();
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    @Deprecated
    public void abortTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getTransaction();
        if (transaction == null) {
            Assert.fail((String)"No transaction exists");
            return;
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case ABORTED: {
                break;
            }
            case COMMITTED: {
                Assert.fail((String)("Transaction is in state of '" + state + "'"));
                break;
            }
            case IN_PROGRESS: 
            case MUST_ABORT: {
                transactionManager.abortTransaction();
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    public <T> T getService(Class<T> serviceClass) {
        if (serviceClass == DomainObjectContainer.class) {
            return (T)this.getContainer();
        }
        ServicesInjectorSpi servicesInjector = this.getPersistenceSession().getServicesInjector();
        Object service = servicesInjector.lookupService(serviceClass);
        if (service == null) {
            throw new RuntimeException("Could not find a service of type: " + serviceClass.getName());
        }
        return (T)service;
    }

    public <T> void replaceService(T originalService, T replacementService) {
        ServicesInjectorSpi servicesInjector = this.getPersistenceSession().getServicesInjector();
        servicesInjector.replaceService(originalService, replacementService);
    }

    @Deprecated
    public void installFixtures(InstallableFixture ... fixtures) {
        FixturesInstallerDelegate fid = new FixturesInstallerDelegate(this.getPersistenceSession());
        for (InstallableFixture fixture : fixtures) {
            fid.addFixture((Object)fixture);
        }
        fid.installFixtures();
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getTransaction();
        IsisTransaction.State transactionState = transaction.getState();
        if (transactionState.canCommit()) {
            this.commitTran();
            try {
                this.bounceSystem();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.beginTran();
        }
    }

    protected IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }

    public PersistenceSession getPersistor() {
        return this.getPersistenceSession();
    }

    public AdapterManager getAdapterManager() {
        return this.getPersistor().getAdapterManager();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    @Deprecated
    public void setContainer(DomainObjectContainer container) {
    }

    private static enum FireListeners {
        FIRE,
        DONT_FIRE;


        public boolean shouldFire() {
            return this == FIRE;
        }
    }

    public static class Builder {
        private AuthenticationRequest authenticationRequest = new AuthenticationRequestNameOnly("tester");
        private IsisConfigurationDefault configuration = new IsisConfigurationDefault();
        private AppManifest appManifestIfAny;
        private MetaModelValidator metaModelValidatorOverride;
        private ProgrammingModel programmingModelOverride;
        private final List<Object> services = Lists.newArrayList();
        private final List<InstallableFixture> fixtures = Lists.newArrayList();
        private final List<Listener> listeners = Lists.newArrayList();
        private Level level;

        public Builder with(IsisConfiguration configuration) {
            this.configuration = (IsisConfigurationDefault)configuration;
            return this;
        }

        @Deprecated
        public Builder with(PersistenceMechanismInstaller persistenceMechanismInstaller) {
            return this;
        }

        public Builder with(MetaModelValidator metaModelValidator) {
            this.metaModelValidatorOverride = metaModelValidator;
            return this;
        }

        public Builder with(ProgrammingModel programmingModel) {
            this.programmingModelOverride = programmingModel;
            return this;
        }

        public Builder with(AuthenticationRequest authenticationRequest) {
            this.authenticationRequest = authenticationRequest;
            return this;
        }

        public Builder with(AppManifest appManifest) {
            this.appManifestIfAny = appManifest;
            return this;
        }

        public Builder withServicesIn(String ... packagePrefixes) {
            if (this.appManifestIfAny != null) {
                throw new IllegalStateException("An appManifest has already been provided; instead use AppManifest#getAdditionalServices()");
            }
            if (packagePrefixes.length == 0) {
                throw new IllegalArgumentException("Specify packagePrefixes to search for @DomainService-annotated services");
            }
            this.configuration.put("isis.services.ServicesInstallerFromAnnotation.packagePrefix", Joiner.on((String)",").join((Object[])packagePrefixes));
            ServicesInstallerFromConfigurationAndAnnotation installer = new ServicesInstallerFromConfigurationAndAnnotation();
            installer.setConfiguration((IsisConfiguration)this.configuration);
            List serviceList = installer.getServices();
            this.services.addAll(serviceList);
            installer.init();
            return this;
        }

        public Builder withServices(Object ... services) {
            if (this.appManifestIfAny != null) {
                throw new IllegalStateException("An appManifest has already been provided");
            }
            this.services.addAll(Arrays.asList(services));
            return this;
        }

        @Deprecated
        public Builder withFixtures(InstallableFixture ... fixtures) {
            if (this.appManifestIfAny != null) {
                throw new IllegalStateException("An appManifest has already been provided");
            }
            this.fixtures.addAll(Arrays.asList(fixtures));
            return this;
        }

        public Builder withLoggingAt(Level level) {
            this.level = level;
            return this;
        }

        public IsisSystemForTest build() {
            final IsisSystemForTest isisSystem = new IsisSystemForTest(this.appManifestIfAny, (IsisConfiguration)this.configuration, this.services, this.fixtures, this.programmingModelOverride, this.metaModelValidatorOverride, this.authenticationRequest, this.listeners);
            if (this.level != null) {
                isisSystem.setLevel(this.level);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public synchronized void run() {
                    try {
                        if (isisSystem != null) {
                            isisSystem.tearDownSystem();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (isisSystem != null) {
                            isisSystem.shutdown();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        IsisContext.shutdown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return isisSystem;
        }

        public Builder with(Listener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
            return this;
        }
    }

    public static abstract class ListenerAdapter
    implements Listener {
        private IsisConfiguration configuration;

        @Override
        public void init(IsisConfiguration configuration) throws Exception {
            this.configuration = configuration;
        }

        protected IsisConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public void preSetupSystem(boolean firstTime) throws Exception {
        }

        @Override
        public void postSetupSystem(boolean firstTime) throws Exception {
        }

        @Override
        public void preBounceSystem() throws Exception {
        }

        @Override
        public void postBounceSystem() throws Exception {
        }

        @Override
        public void preTeardownSystem() throws Exception {
        }

        @Override
        public void postTeardownSystem() throws Exception {
        }
    }

    public static interface Listener {
        public void init(IsisConfiguration var1) throws Exception;

        public void preSetupSystem(boolean var1) throws Exception;

        public void postSetupSystem(boolean var1) throws Exception;

        public void preBounceSystem() throws Exception;

        public void postBounceSystem() throws Exception;

        public void preTeardownSystem() throws Exception;

        public void postTeardownSystem() throws Exception;
    }
}

