/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publish;

import org.apache.isis.applib.annotation.NotPersistable;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.publish.EventPayload;
import org.apache.isis.applib.services.publish.ObjectStringifier;

@NotPersistable
public class EventPayloadForObjectChanged<T>
implements EventPayload {
    private final T changed;
    private ObjectStringifier stringifier;

    public EventPayloadForObjectChanged(T changed) {
        this.changed = changed;
    }

    @Override
    @Programmatic
    public void withStringifier(ObjectStringifier stringifier) {
        this.stringifier = stringifier;
    }

    public T getChanged() {
        return this.changed;
    }

    public String getClassName() {
        if (this.stringifier == null) {
            throw new IllegalStateException("ObjectStringifier has not been injected");
        }
        return this.stringifier.classNameOf(this.changed);
    }

    public String toString() {
        if (this.stringifier == null) {
            throw new IllegalStateException("ObjectStringifier has not been injected");
        }
        return this.stringifier.toString(this.changed);
    }
}

