/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publish;

import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.NotPersistable;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.publish.EventPayload;
import org.apache.isis.applib.services.publish.ObjectStringifier;

@NotPersistable
public class EventPayloadForActionInvocation<T>
implements EventPayload {
    private final Identifier actionIdentifier;
    private final T target;
    private final List<? extends Object> arguments;
    private final Object result;
    private ObjectStringifier stringifier;

    public EventPayloadForActionInvocation(Identifier actionIdentifier, T target, List<? extends Object> arguments, Object result) {
        this.target = target;
        this.actionIdentifier = actionIdentifier;
        this.arguments = arguments != null ? arguments : Collections.emptyList();
        this.result = result;
    }

    @Override
    @Programmatic
    public void withStringifier(ObjectStringifier stringifier) {
        this.stringifier = stringifier;
    }

    @Programmatic
    public List<? extends Object> getArguments() {
        return this.arguments;
    }

    public T getTarget() {
        return this.target;
    }

    public String getActionName() {
        return this.actionIdentifier.toFullIdentityString();
    }

    public Object getArg0() {
        return this.getArg(0);
    }

    public boolean hideArg0() {
        return this.hideArg(0);
    }

    public Object getArg1() {
        return this.getArg(1);
    }

    public boolean hideArg1() {
        return this.hideArg(1);
    }

    public Object getArg2() {
        return this.getArg(2);
    }

    public boolean hideArg2() {
        return this.hideArg(2);
    }

    public Object getArg3() {
        return this.getArg(3);
    }

    public boolean hideArg3() {
        return this.hideArg(3);
    }

    public Object getArg4() {
        return this.getArg(4);
    }

    public boolean hideArg4() {
        return this.hideArg(4);
    }

    public Object getArg5() {
        return this.getArg(5);
    }

    public boolean hideArg5() {
        return this.hideArg(5);
    }

    public Object getArg6() {
        return this.getArg(6);
    }

    public boolean hideArg6() {
        return this.hideArg(6);
    }

    public Object getArg7() {
        return this.getArg(7);
    }

    public boolean hideArg7() {
        return this.hideArg(7);
    }

    public Object getArg8() {
        return this.getArg(8);
    }

    public boolean hideArg8() {
        return this.hideArg(8);
    }

    public Object getArg9() {
        return this.getArg(9);
    }

    public boolean hideArg9() {
        return this.hideArg(9);
    }

    public Object getResult() {
        return this.result;
    }

    private Object getArg(int paramNum) {
        return this.arguments.size() > paramNum ? this.arguments.get(paramNum) : null;
    }

    private boolean hideArg(int paramNum) {
        return this.arguments.size() <= paramNum;
    }

    public String toString() {
        if (this.stringifier == null) {
            throw new IllegalStateException("ObjectStringifier has not been injected");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.getActionName());
        buf.append("\n    target=").append(this.stringifier.toString(this.target));
        buf.append("\n      args=[");
        for (Object object : this.arguments) {
            buf.append("\n           ").append(this.stringifier.toString(object));
        }
        buf.append("\n      ]");
        String stringifiedResult = this.stringifier.toString(this.result);
        buf.append("\n    result=").append(stringifiedResult != null ? stringifiedResult : "void");
        return buf.toString();
    }
}

