/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.i18n;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.i18n.TranslationService;

public final class TranslatableString {
    private final String singularText;
    private final String pluralText;
    private final Type type;
    private final int number;
    private final Map<String, Object> argumentsByParameterName;

    public static TranslatableString tr(String pattern, Object ... paramArgs) {
        if (pattern == null) {
            return null;
        }
        return new TranslatableString(Type.TR, pattern, null, 1, TranslatableString.asMap(paramArgs));
    }

    public static TranslatableString trn(String singularPattern, String pluralPattern, int number, Object ... paramArgs) {
        return new TranslatableString(Type.TRN, singularPattern, pluralPattern, number, TranslatableString.asMap(paramArgs));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Object> asMap(Object[] paramArgs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean param = true;
        String paramStr = null;
        for (Object paramArg : paramArgs) {
            if (param) {
                if (!(paramArg instanceof String)) throw new IllegalArgumentException("Parameter must be a string");
                paramStr = (String)paramArg;
            } else {
                Object arg = paramArg;
                map.put(paramStr, arg);
                paramStr = null;
            }
            param = !param;
        }
        if (paramStr == null) return map;
        throw new IllegalArgumentException("Must have equal number of parameters and arguments");
    }

    private TranslatableString(Type type, String singularText, String pluralText, int number, Map<String, Object> argumentsByParameterName) {
        this.type = type;
        this.singularText = singularText;
        this.pluralText = pluralText;
        this.number = number;
        this.argumentsByParameterName = argumentsByParameterName;
    }

    String getSingularText() {
        return this.singularText;
    }

    String getPluralText() {
        return this.pluralText;
    }

    boolean isPluralForm() {
        return this.type == Type.TRN;
    }

    Map<String, Object> getArgumentsByParameterName() {
        return this.argumentsByParameterName;
    }

    @Programmatic
    public String translate(TranslationService translationService, String context) {
        String translatedText = !this.isPluralForm() ? translationService.translate(context, this.getSingularText()) : translationService.translate(context, this.getSingularText(), this.getPluralText(), this.number);
        return this.translated(translatedText);
    }

    public String getPattern() {
        return !this.isPluralForm() || this.number == 1 ? this.getSingularText() : this.getPluralText();
    }

    String translated(String translatedText) {
        return TranslatableString.format(translatedText, this.argumentsByParameterName);
    }

    static String format(String format, Map<String, Object> values) {
        StringBuilder formatter = new StringBuilder(format);
        ArrayList valueList = Lists.newArrayList();
        Matcher matcher = Pattern.compile("\\{(\\w+)}").matcher(format);
        while (matcher.find()) {
            String key = matcher.group(1);
            String formatKey = String.format("{%s}", key);
            int index = formatter.indexOf(formatKey);
            if (index == -1) continue;
            formatter.replace(index, index + formatKey.length(), "%s");
            valueList.add(values.get(key));
        }
        return String.format(formatter.toString(), valueList.toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslatableString that = (TranslatableString)o;
        if (this.pluralText != null ? !this.pluralText.equals(that.pluralText) : that.pluralText != null) {
            return false;
        }
        if (this.singularText != null ? !this.singularText.equals(that.singularText) : that.singularText != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.singularText != null ? this.singularText.hashCode() : 0);
        result = 31 * result + (this.pluralText != null ? this.pluralText.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.type.toString(this);
    }

    private static enum Type {
        TR{

            @Override
            public String toString(TranslatableString trString) {
                return "tr: " + trString.singularText;
            }
        }
        ,
        TRN{

            @Override
            public String toString(TranslatableString trString) {
                return "trn: " + trString.pluralText;
            }
        };


        public abstract String toString(TranslatableString var1);
    }
}

