/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.eventbus;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.eventbus.AbstractInteractionEvent;
import org.apache.isis.applib.services.eventbus.ActionInteractionEvent;
import org.apache.isis.applib.util.ObjectContracts;

public abstract class ActionDomainEvent<S>
extends AbstractInteractionEvent<S> {
    private static final long serialVersionUID = 1L;
    private Command command;
    private ActionSemantics.Of actionSemantics;
    private List<String> parameterNames;
    private List<Class<?>> parameterTypes;
    private List<Object> arguments;
    private Object returnValue;

    public ActionDomainEvent(S source, Identifier identifier) {
        super(source, identifier);
    }

    public ActionDomainEvent(S source, Identifier identifier, Object ... arguments) {
        this(source, identifier, arguments != null ? Arrays.asList(arguments) : Collections.emptyList());
    }

    public ActionDomainEvent(S source, Identifier identifier, List<Object> arguments) {
        this(source, identifier);
        this.arguments = Collections.unmodifiableList(arguments);
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public SemanticsOf getSemantics() {
        return SemanticsOf.from(this.actionSemantics);
    }

    @Deprecated
    public ActionSemantics.Of getActionSemantics() {
        return this.actionSemantics;
    }

    public void setActionSemantics(ActionSemantics.Of actionSemantics) {
        this.actionSemantics = actionSemantics;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(List<Class<?>> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Object> arguments) {
        this.arguments = arguments;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    public String toString() {
        return ObjectContracts.toString((Object)this, "source,identifier,phase");
    }

    public static class Default
    extends ActionInteractionEvent<Object> {
        private static final long serialVersionUID = 1L;

        public Default(Object source, Identifier identifier, Object ... arguments) {
            super(source, identifier, arguments);
        }
    }
}

