/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.actinvoc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.InvokedOn;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;

@DomainService(nature=NatureOfService.DOMAIN)
@RequestScoped
public class ActionInvocationContext {
    private InvokedOn invokedOn;
    private List<Object> domainObjects;
    private int index;

    public static ActionInvocationContext onObject(Object domainObject) {
        return new ActionInvocationContext(InvokedOn.OBJECT, Collections.singletonList(domainObject));
    }

    public static ActionInvocationContext onCollection(Object ... domainObjects) {
        return ActionInvocationContext.onCollection(Arrays.asList(domainObjects));
    }

    public static ActionInvocationContext onCollection(List<Object> domainObjects) {
        return new ActionInvocationContext(InvokedOn.COLLECTION, domainObjects);
    }

    public ActionInvocationContext() {
    }

    @Deprecated
    public ActionInvocationContext(InvokedOn invokedOn, Object ... domainObjects) {
        this(invokedOn, Arrays.asList(domainObjects));
    }

    @Deprecated
    public ActionInvocationContext(InvokedOn invokedOn, List<Object> domainObjects) {
        this.invokedOn = invokedOn;
        this.domainObjects = domainObjects;
    }

    @Programmatic
    public void setInvokedOn(InvokedOn invokedOn) {
        this.invokedOn = invokedOn;
    }

    @Programmatic
    public void setDomainObjects(List<Object> domainObjects) {
        this.domainObjects = domainObjects;
    }

    @Programmatic
    public void setIndex(int index) {
        this.index = index;
    }

    @Programmatic
    public InvokedOn getInvokedOn() {
        return this.invokedOn;
    }

    @Programmatic
    public List<Object> getDomainObjects() {
        return this.domainObjects;
    }

    @Programmatic
    public int getSize() {
        return this.domainObjects.size();
    }

    @Programmatic
    public int getIndex() {
        return this.index;
    }

    @Programmatic
    public boolean isFirst() {
        return this.index == 0;
    }

    @Programmatic
    public boolean isLast() {
        return this.index == this.getSize() - 1;
    }
}

